<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoverningCarrierOverrideType Structs
 * @subpackage Structs
 */
class GoverningCarrierOverrideType extends AbstractStructBase
{
    /**
     * The AirlineCode
     * Meta informations extracted from the WSDL
     * - documentation: Airline Carrier Code - override the GOVERNING CARRIER to get the fare filed by that carrier.
     * - use: required
     * - pattern: [0-9A-Z]{2,3}
     * @var string
     */
    public $AirlineCode;
    /**
     * Constructor method for GoverningCarrierOverrideType
     * @uses GoverningCarrierOverrideType::setAirlineCode()
     * @param string $airlineCode
     */
    public function __construct($airlineCode = null)
    {
        $this
            ->setAirlineCode($airlineCode);
    }
    /**
     * Get AirlineCode value
     * @return string
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \Sabre\BargainFinderMax\Structs\GoverningCarrierOverrideType
     */
    public function setAirlineCode($airlineCode = null)
    {
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\GoverningCarrierOverrideType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
