<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FrequentFlyer Structs
 * Meta informations extracted from the WSDL
 * - documentation: Frequent Flyer Status Information
 * @subpackage Structs
 */
class FrequentFlyer extends AbstractStructBase
{
    /**
     * The Tier
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Tier;
    /**
     * The Carrier
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Carrier;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Frequent Flyer Status
     * - use: required
     * @var int
     */
    public $Status;
    /**
     * The AirlineCode
     * Meta informations extracted from the WSDL
     * - documentation: Airline Carrier Code
     * @var string
     */
    public $AirlineCode;
    /**
     * Constructor method for FrequentFlyer
     * @uses FrequentFlyer::setTier()
     * @uses FrequentFlyer::setCarrier()
     * @uses FrequentFlyer::setStatus()
     * @uses FrequentFlyer::setAirlineCode()
     * @param int $tier
     * @param string $carrier
     * @param int $status
     * @param string $airlineCode
     */
    public function __construct($tier = null, $carrier = null, $status = null, $airlineCode = null)
    {
        $this
            ->setTier($tier)
            ->setCarrier($carrier)
            ->setStatus($status)
            ->setAirlineCode($airlineCode);
    }
    /**
     * Get Tier value
     * @return int
     */
    public function getTier()
    {
        return $this->Tier;
    }
    /**
     * Set Tier value
     * @param int $tier
     * @return \Sabre\BargainFinderMax\Structs\FrequentFlyer
     */
    public function setTier($tier = null)
    {
        $this->Tier = $tier;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \Sabre\BargainFinderMax\Structs\FrequentFlyer
     */
    public function setCarrier($carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Sabre\BargainFinderMax\Structs\FrequentFlyer
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \Sabre\BargainFinderMax\Structs\FrequentFlyer
     */
    public function setAirlineCode($airlineCode = null)
    {
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FrequentFlyer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
