<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightTypePrefType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Indicates preferences for certain types of flights, such as connections or stopovers, when used for a specific travel situation.
 * @subpackage Structs
 */
class FlightTypePrefType extends AbstractStructBase
{
    /**
     * The FlightType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FlightType;
    /**
     * The MaxConnections
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MaxConnections;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for FlightTypePrefType
     * @uses FlightTypePrefType::setFlightType()
     * @uses FlightTypePrefType::setMaxConnections()
     * @uses FlightTypePrefType::setPreferLevel()
     * @param string $flightType
     * @param string $maxConnections
     * @param string $preferLevel
     */
    public function __construct($flightType = null, $maxConnections = null, $preferLevel = null)
    {
        $this
            ->setFlightType($flightType)
            ->setMaxConnections($maxConnections)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get FlightType value
     * @return string|null
     */
    public function getFlightType()
    {
        return $this->FlightType;
    }
    /**
     * Set FlightType value
     * @uses \Sabre\BargainFinderMax\Enums\FlightTypeType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\FlightTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flightType
     * @return \Sabre\BargainFinderMax\Structs\FlightTypePrefType
     */
    public function setFlightType($flightType = null)
    {
        $this->FlightType = $flightType;
        return $this;
    }
    /**
     * Get MaxConnections value
     * @return string|null
     */
    public function getMaxConnections()
    {
        return $this->MaxConnections;
    }
    /**
     * Set MaxConnections value
     * @param string $maxConnections
     * @return \Sabre\BargainFinderMax\Structs\FlightTypePrefType
     */
    public function setMaxConnections($maxConnections = null)
    {
        $this->MaxConnections = $maxConnections;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \Sabre\BargainFinderMax\Structs\FlightTypePrefType
     */
    public function setPreferLevel($preferLevel = null)
    {
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FlightTypePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
