<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fees Structs
 * Meta informations extracted from the WSDL
 * - documentation: This is a collection of Fees
 * @subpackage Structs
 */
class Fees extends AbstractStructBase
{
    /**
     * The Fee
     * Meta informations extracted from the WSDL
     * - documentation: Any additional fee incurred by the passenger but not shown on the ticket.
     * - maxOccurs: 9
     * @var \Sabre\BargainFinderMax\Structs\AirFeeType[]
     */
    public $Fee;
    /**
     * Constructor method for Fees
     * @uses Fees::setFee()
     * @param \Sabre\BargainFinderMax\Structs\AirFeeType[] $fee
     */
    public function __construct(array $fee = array())
    {
        $this
            ->setFee($fee);
    }
    /**
     * Get Fee value
     * @return \Sabre\BargainFinderMax\Structs\AirFeeType[]|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * Set Fee value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirFeeType[] $fee
     * @return \Sabre\BargainFinderMax\Structs\Fees
     */
    public function setFee(array $fee = array())
    {
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Add item to Fee value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirFeeType $item
     * @return \Sabre\BargainFinderMax\Structs\Fees
     */
    public function addToFee(\Sabre\BargainFinderMax\Structs\AirFeeType $item)
    {
        $this->Fee[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Fees
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
