<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareOptionalDetailsType Structs
 * Meta informations extracted from the WSDL
 * - documentation: You don't need to specify all of these attributes for a given flight. For some of them it is sufficient to be specified in the last flight of a given fare component. For details, see notes below --- the attributes are annotated with
 * ,,last Flight in Fare Component''.
 * @subpackage Structs
 */
class FareOptionalDetailsType extends AbstractStructBase
{
    /**
     * The ComponentNo
     * Meta informations extracted from the WSDL
     * - documentation: Fare component number
     * - use: optional
     * @var int
     */
    public $ComponentNo;
    /**
     * The BasisCode
     * Meta informations extracted from the WSDL
     * - documentation: Fare basis code
     * - use: optional
     * - maxLength: 15
     * - minLength: 1
     * - pattern: [A-Z0-9]+(/[A-Z0-9]+)?
     * @var string
     */
    public $BasisCode;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Fare amount (note: last Flight in Fare Component) | Used for amounts, max 3 decimals
     * - use: optional
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - documentation: Vendor (note: last Flight in Fare Component)
     * @var string
     */
    public $Vendor;
    /**
     * The SourceVendor
     * Meta informations extracted from the WSDL
     * - documentation: Fare Source Vendor (note: last Flight in Fare Component)
     * - pattern: [0-9A-Z]{2,3}
     * @var string
     */
    public $SourceVendor;
    /**
     * The Tariff
     * Meta informations extracted from the WSDL
     * - documentation: Tariff (note: last Flight in Fare Component)
     * @var string
     */
    public $Tariff;
    /**
     * The RuleNumber
     * Meta informations extracted from the WSDL
     * - documentation: Rule Number (note: last Flight in Fare Component)
     * @var string
     */
    public $RuleNumber;
    /**
     * The BrandID
     * @var string
     */
    public $BrandID;
    /**
     * The ProgramID
     * @var int
     */
    public $ProgramID;
    /**
     * Constructor method for FareOptionalDetailsType
     * @uses FareOptionalDetailsType::setComponentNo()
     * @uses FareOptionalDetailsType::setBasisCode()
     * @uses FareOptionalDetailsType::setAmount()
     * @uses FareOptionalDetailsType::setVendor()
     * @uses FareOptionalDetailsType::setSourceVendor()
     * @uses FareOptionalDetailsType::setTariff()
     * @uses FareOptionalDetailsType::setRuleNumber()
     * @uses FareOptionalDetailsType::setBrandID()
     * @uses FareOptionalDetailsType::setProgramID()
     * @param int $componentNo
     * @param string $basisCode
     * @param float $amount
     * @param string $vendor
     * @param string $sourceVendor
     * @param string $tariff
     * @param string $ruleNumber
     * @param string $brandID
     * @param int $programID
     */
    public function __construct($componentNo = null, $basisCode = null, $amount = null, $vendor = null, $sourceVendor = null, $tariff = null, $ruleNumber = null, $brandID = null, $programID = null)
    {
        $this
            ->setComponentNo($componentNo)
            ->setBasisCode($basisCode)
            ->setAmount($amount)
            ->setVendor($vendor)
            ->setSourceVendor($sourceVendor)
            ->setTariff($tariff)
            ->setRuleNumber($ruleNumber)
            ->setBrandID($brandID)
            ->setProgramID($programID);
    }
    /**
     * Get ComponentNo value
     * @return int|null
     */
    public function getComponentNo()
    {
        return $this->ComponentNo;
    }
    /**
     * Set ComponentNo value
     * @param int $componentNo
     * @return \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType
     */
    public function setComponentNo($componentNo = null)
    {
        $this->ComponentNo = $componentNo;
        return $this;
    }
    /**
     * Get BasisCode value
     * @return string|null
     */
    public function getBasisCode()
    {
        return $this->BasisCode;
    }
    /**
     * Set BasisCode value
     * @param string $basisCode
     * @return \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType
     */
    public function setBasisCode($basisCode = null)
    {
        $this->BasisCode = $basisCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Vendor value
     * @return string|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param string $vendor
     * @return \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType
     */
    public function setVendor($vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get SourceVendor value
     * @return string|null
     */
    public function getSourceVendor()
    {
        return $this->SourceVendor;
    }
    /**
     * Set SourceVendor value
     * @param string $sourceVendor
     * @return \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType
     */
    public function setSourceVendor($sourceVendor = null)
    {
        $this->SourceVendor = $sourceVendor;
        return $this;
    }
    /**
     * Get Tariff value
     * @return string|null
     */
    public function getTariff()
    {
        return $this->Tariff;
    }
    /**
     * Set Tariff value
     * @param string $tariff
     * @return \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType
     */
    public function setTariff($tariff = null)
    {
        $this->Tariff = $tariff;
        return $this;
    }
    /**
     * Get RuleNumber value
     * @return string|null
     */
    public function getRuleNumber()
    {
        return $this->RuleNumber;
    }
    /**
     * Set RuleNumber value
     * @param string $ruleNumber
     * @return \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType
     */
    public function setRuleNumber($ruleNumber = null)
    {
        $this->RuleNumber = $ruleNumber;
        return $this;
    }
    /**
     * Get BrandID value
     * @return string|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param string $brandID
     * @return \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType
     */
    public function setBrandID($brandID = null)
    {
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return int|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param int $programID
     * @return \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType
     */
    public function setProgramID($programID = null)
    {
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
