<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponent Structs
 * Meta informations extracted from the WSDL
 * - documentation: Subtotal pricing summary for Fare Component.
 * @subpackage Structs
 */
class FareComponent extends AbstractStructBase
{
    /**
     * The BaseFare
     * Meta informations extracted from the WSDL
     * - documentation: Price of the inventory excluding taxes and fees.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CurrencyAmountType
     */
    public $BaseFare;
    /**
     * The EquivFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\EquivFare
     */
    public $EquivFare;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Taxes
     */
    public $Taxes;
    /**
     * The TotalFare
     * Meta informations extracted from the WSDL
     * - documentation: The total price that the passenger would pay (includes fare, taxes, fees)
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CurrencyAmountType
     */
    public $TotalFare;
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Segment[]
     */
    public $Segment;
    /**
     * The HandlingMarkupDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail[]
     */
    public $HandlingMarkupDetail;
    /**
     * The FareRetailerRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FareRetailerRule[]
     */
    public $FareRetailerRule;
    /**
     * The BrandFeatureRef
     * Meta informations extracted from the WSDL
     * - documentation: References to brand feature items in the final list
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\BrandFeatureRefType[]
     */
    public $BrandFeatureRef;
    /**
     * The ProgramID
     * @var string
     */
    public $ProgramID;
    /**
     * The ProgramCode
     * @var string
     */
    public $ProgramCode;
    /**
     * The ProgramDescription
     * Meta informations extracted from the WSDL
     * - documentation: Used to indicate program description
     * - use: optional
     * @var string
     */
    public $ProgramDescription;
    /**
     * The ProgramSystemCode
     * @var string
     */
    public $ProgramSystemCode;
    /**
     * The BrandID
     * Meta informations extracted from the WSDL
     * - documentation: Used to indicate brand code
     * - use: optional
     * @var string
     */
    public $BrandID;
    /**
     * The BrandName
     * Meta informations extracted from the WSDL
     * - documentation: Used to indicate brand name
     * - use: optional
     * @var string
     */
    public $BrandName;
    /**
     * Constructor method for FareComponent
     * @uses FareComponent::setBaseFare()
     * @uses FareComponent::setEquivFare()
     * @uses FareComponent::setTaxes()
     * @uses FareComponent::setTotalFare()
     * @uses FareComponent::setSegment()
     * @uses FareComponent::setHandlingMarkupDetail()
     * @uses FareComponent::setFareRetailerRule()
     * @uses FareComponent::setBrandFeatureRef()
     * @uses FareComponent::setProgramID()
     * @uses FareComponent::setProgramCode()
     * @uses FareComponent::setProgramDescription()
     * @uses FareComponent::setProgramSystemCode()
     * @uses FareComponent::setBrandID()
     * @uses FareComponent::setBrandName()
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $baseFare
     * @param \Sabre\BargainFinderMax\Structs\EquivFare $equivFare
     * @param \Sabre\BargainFinderMax\Structs\Taxes $taxes
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalFare
     * @param \Sabre\BargainFinderMax\Structs\Segment[] $segment
     * @param \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail[] $handlingMarkupDetail
     * @param \Sabre\BargainFinderMax\Structs\FareRetailerRule[] $fareRetailerRule
     * @param \Sabre\BargainFinderMax\Structs\BrandFeatureRefType[] $brandFeatureRef
     * @param string $programID
     * @param string $programCode
     * @param string $programDescription
     * @param string $programSystemCode
     * @param string $brandID
     * @param string $brandName
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\CurrencyAmountType $baseFare = null, \Sabre\BargainFinderMax\Structs\EquivFare $equivFare = null, \Sabre\BargainFinderMax\Structs\Taxes $taxes = null, \Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalFare = null, array $segment = array(), array $handlingMarkupDetail = array(), array $fareRetailerRule = array(), array $brandFeatureRef = array(), $programID = null, $programCode = null, $programDescription = null, $programSystemCode = null, $brandID = null, $brandName = null)
    {
        $this
            ->setBaseFare($baseFare)
            ->setEquivFare($equivFare)
            ->setTaxes($taxes)
            ->setTotalFare($totalFare)
            ->setSegment($segment)
            ->setHandlingMarkupDetail($handlingMarkupDetail)
            ->setFareRetailerRule($fareRetailerRule)
            ->setBrandFeatureRef($brandFeatureRef)
            ->setProgramID($programID)
            ->setProgramCode($programCode)
            ->setProgramDescription($programDescription)
            ->setProgramSystemCode($programSystemCode)
            ->setBrandID($brandID)
            ->setBrandName($brandName);
    }
    /**
     * Get BaseFare value
     * @return \Sabre\BargainFinderMax\Structs\CurrencyAmountType|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $baseFare
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setBaseFare(\Sabre\BargainFinderMax\Structs\CurrencyAmountType $baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get EquivFare value
     * @return \Sabre\BargainFinderMax\Structs\EquivFare|null
     */
    public function getEquivFare()
    {
        return $this->EquivFare;
    }
    /**
     * Set EquivFare value
     * @param \Sabre\BargainFinderMax\Structs\EquivFare $equivFare
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setEquivFare(\Sabre\BargainFinderMax\Structs\EquivFare $equivFare = null)
    {
        $this->EquivFare = $equivFare;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \Sabre\BargainFinderMax\Structs\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \Sabre\BargainFinderMax\Structs\Taxes $taxes
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setTaxes(\Sabre\BargainFinderMax\Structs\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \Sabre\BargainFinderMax\Structs\CurrencyAmountType|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalFare
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setTotalFare(\Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get Segment value
     * @return \Sabre\BargainFinderMax\Structs\Segment[]|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Segment[] $segment
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setSegment(array $segment = array())
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Segment $item
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function addToSegment(\Sabre\BargainFinderMax\Structs\Segment $item)
    {
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Get HandlingMarkupDetail value
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail[]|null
     */
    public function getHandlingMarkupDetail()
    {
        return $this->HandlingMarkupDetail;
    }
    /**
     * Set HandlingMarkupDetail value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail[] $handlingMarkupDetail
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setHandlingMarkupDetail(array $handlingMarkupDetail = array())
    {
        $this->HandlingMarkupDetail = $handlingMarkupDetail;
        return $this;
    }
    /**
     * Add item to HandlingMarkupDetail value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail $item
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function addToHandlingMarkupDetail(\Sabre\BargainFinderMax\Structs\HandlingMarkupDetail $item)
    {
        $this->HandlingMarkupDetail[] = $item;
        return $this;
    }
    /**
     * Get FareRetailerRule value
     * @return \Sabre\BargainFinderMax\Structs\FareRetailerRule[]|null
     */
    public function getFareRetailerRule()
    {
        return $this->FareRetailerRule;
    }
    /**
     * Set FareRetailerRule value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareRetailerRule[] $fareRetailerRule
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setFareRetailerRule(array $fareRetailerRule = array())
    {
        $this->FareRetailerRule = $fareRetailerRule;
        return $this;
    }
    /**
     * Add item to FareRetailerRule value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareRetailerRule $item
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function addToFareRetailerRule(\Sabre\BargainFinderMax\Structs\FareRetailerRule $item)
    {
        $this->FareRetailerRule[] = $item;
        return $this;
    }
    /**
     * Get BrandFeatureRef value
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureRefType[]|null
     */
    public function getBrandFeatureRef()
    {
        return $this->BrandFeatureRef;
    }
    /**
     * Set BrandFeatureRef value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BrandFeatureRefType[] $brandFeatureRef
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setBrandFeatureRef(array $brandFeatureRef = array())
    {
        $this->BrandFeatureRef = $brandFeatureRef;
        return $this;
    }
    /**
     * Add item to BrandFeatureRef value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BrandFeatureRefType $item
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function addToBrandFeatureRef(\Sabre\BargainFinderMax\Structs\BrandFeatureRefType $item)
    {
        $this->BrandFeatureRef[] = $item;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setProgramID($programID = null)
    {
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setProgramCode($programCode = null)
    {
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get ProgramDescription value
     * @return string|null
     */
    public function getProgramDescription()
    {
        return $this->ProgramDescription;
    }
    /**
     * Set ProgramDescription value
     * @param string $programDescription
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setProgramDescription($programDescription = null)
    {
        $this->ProgramDescription = $programDescription;
        return $this;
    }
    /**
     * Get ProgramSystemCode value
     * @return string|null
     */
    public function getProgramSystemCode()
    {
        return $this->ProgramSystemCode;
    }
    /**
     * Set ProgramSystemCode value
     * @param string $programSystemCode
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setProgramSystemCode($programSystemCode = null)
    {
        $this->ProgramSystemCode = $programSystemCode;
        return $this;
    }
    /**
     * Get BrandID value
     * @return string|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param string $brandID
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setBrandID($brandID = null)
    {
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public function setBrandName($brandName = null)
    {
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
