<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareBasisCodes Structs
 * Meta informations extracted from the WSDL
 * - documentation: This is a collection of Fare Basis Codes
 * @subpackage Structs
 */
class FareBasisCodes extends AbstractStructBase
{
    /**
     * The FareBasisCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 400
     * @var \Sabre\BargainFinderMax\Structs\FareBasisCode[]
     */
    public $FareBasisCode;
    /**
     * Constructor method for FareBasisCodes
     * @uses FareBasisCodes::setFareBasisCode()
     * @param \Sabre\BargainFinderMax\Structs\FareBasisCode[] $fareBasisCode
     */
    public function __construct(array $fareBasisCode = array())
    {
        $this
            ->setFareBasisCode($fareBasisCode);
    }
    /**
     * Get FareBasisCode value
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode[]|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareBasisCode[] $fareBasisCode
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCodes
     */
    public function setFareBasisCode(array $fareBasisCode = array())
    {
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Add item to FareBasisCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareBasisCode $item
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCodes
     */
    public function addToFareBasisCode(\Sabre\BargainFinderMax\Structs\FareBasisCode $item)
    {
        $this->FareBasisCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
