<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeType Structs
 * @subpackage Structs
 */
class ExchangeType extends AbstractStructBase
{
    /**
     * The Fare
     * @var \Sabre\BargainFinderMax\Structs\ExchangeFareType
     */
    public $Fare;
    /**
     * The POS
     * @var \Sabre\BargainFinderMax\Structs\ExchangePOSType
     */
    public $POS;
    /**
     * The OriginDestinationInformation
     * @var \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public $OriginDestinationInformation;
    /**
     * The Arunk
     * @var \Sabre\BargainFinderMax\Structs\ArunkType
     */
    public $Arunk;
    /**
     * The TravelPreferences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ExchangeAirSearchPrefsType
     */
    public $TravelPreferences;
    /**
     * The TravelerInfoSummary
     * @var \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType
     */
    public $TravelerInfoSummary;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ExchangeTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The OriginalTktIssueDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Original ticket issue date and time | IntelliSell DateTime type with optional time component (required format: YYYY-MM-DD or YYYY-MM-DDTHH:MM:SS)
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}(T[0-9]{2}:[0-9]{2}:[0-9]{2})?
     * @var string
     */
    public $OriginalTktIssueDateTime;
    /**
     * The ExchangedTktIssueDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Exchanged ticket issue date and time | IntelliSell DateTime type with optional time component (required format: YYYY-MM-DD or YYYY-MM-DDTHH:MM:SS)
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}(T[0-9]{2}:[0-9]{2}:[0-9]{2})?
     * @var string
     */
    public $ExchangedTktIssueDateTime;
    /**
     * The PreviousExchangeDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Previous exchange date and time | IntelliSell DateTime type with optional time component (required format: YYYY-MM-DD or YYYY-MM-DDTHH:MM:SS)
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}(T[0-9]{2}:[0-9]{2}:[0-9]{2})?
     * @var string
     */
    public $PreviousExchangeDateTime;
    /**
     * The NumberOfTaxBoxes
     * Meta informations extracted from the WSDL
     * - documentation: Number of tax boxes
     * @var int
     */
    public $NumberOfTaxBoxes;
    /**
     * The BypassAdvancePurchaseOption
     * Meta informations extracted from the WSDL
     * - documentation: Bypass Advance Purchase Option | Used for Characters, length 1 | Used for Characters, length 1
     * - length: 1
     * @var string
     */
    public $BypassAdvancePurchaseOption;
    /**
     * Constructor method for ExchangeType
     * @uses ExchangeType::setFare()
     * @uses ExchangeType::setPOS()
     * @uses ExchangeType::setOriginDestinationInformation()
     * @uses ExchangeType::setArunk()
     * @uses ExchangeType::setTravelPreferences()
     * @uses ExchangeType::setTravelerInfoSummary()
     * @uses ExchangeType::setTPA_Extensions()
     * @uses ExchangeType::setOriginalTktIssueDateTime()
     * @uses ExchangeType::setExchangedTktIssueDateTime()
     * @uses ExchangeType::setPreviousExchangeDateTime()
     * @uses ExchangeType::setNumberOfTaxBoxes()
     * @uses ExchangeType::setBypassAdvancePurchaseOption()
     * @param \Sabre\BargainFinderMax\Structs\ExchangeFareType $fare
     * @param \Sabre\BargainFinderMax\Structs\ExchangePOSType $pOS
     * @param \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType $originDestinationInformation
     * @param \Sabre\BargainFinderMax\Structs\ArunkType $arunk
     * @param \Sabre\BargainFinderMax\Structs\ExchangeAirSearchPrefsType $travelPreferences
     * @param \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType $travelerInfoSummary
     * @param \Sabre\BargainFinderMax\Structs\ExchangeTPA_ExtensionsType $tPA_Extensions
     * @param string $originalTktIssueDateTime
     * @param string $exchangedTktIssueDateTime
     * @param string $previousExchangeDateTime
     * @param int $numberOfTaxBoxes
     * @param string $bypassAdvancePurchaseOption
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\ExchangeFareType $fare = null, \Sabre\BargainFinderMax\Structs\ExchangePOSType $pOS = null, \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType $originDestinationInformation = null, \Sabre\BargainFinderMax\Structs\ArunkType $arunk = null, \Sabre\BargainFinderMax\Structs\ExchangeAirSearchPrefsType $travelPreferences = null, \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType $travelerInfoSummary = null, \Sabre\BargainFinderMax\Structs\ExchangeTPA_ExtensionsType $tPA_Extensions = null, $originalTktIssueDateTime = null, $exchangedTktIssueDateTime = null, $previousExchangeDateTime = null, $numberOfTaxBoxes = null, $bypassAdvancePurchaseOption = null)
    {
        $this
            ->setFare($fare)
            ->setPOS($pOS)
            ->setOriginDestinationInformation($originDestinationInformation)
            ->setArunk($arunk)
            ->setTravelPreferences($travelPreferences)
            ->setTravelerInfoSummary($travelerInfoSummary)
            ->setTPA_Extensions($tPA_Extensions)
            ->setOriginalTktIssueDateTime($originalTktIssueDateTime)
            ->setExchangedTktIssueDateTime($exchangedTktIssueDateTime)
            ->setPreviousExchangeDateTime($previousExchangeDateTime)
            ->setNumberOfTaxBoxes($numberOfTaxBoxes)
            ->setBypassAdvancePurchaseOption($bypassAdvancePurchaseOption);
    }
    /**
     * Get Fare value
     * @return \Sabre\BargainFinderMax\Structs\ExchangeFareType|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \Sabre\BargainFinderMax\Structs\ExchangeFareType $fare
     * @return \Sabre\BargainFinderMax\Structs\ExchangeType
     */
    public function setFare(\Sabre\BargainFinderMax\Structs\ExchangeFareType $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get POS value
     * @return \Sabre\BargainFinderMax\Structs\ExchangePOSType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \Sabre\BargainFinderMax\Structs\ExchangePOSType $pOS
     * @return \Sabre\BargainFinderMax\Structs\ExchangeType
     */
    public function setPOS(\Sabre\BargainFinderMax\Structs\ExchangePOSType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get OriginDestinationInformation value
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType|null
     */
    public function getOriginDestinationInformation()
    {
        return $this->OriginDestinationInformation;
    }
    /**
     * Set OriginDestinationInformation value
     * @param \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType $originDestinationInformation
     * @return \Sabre\BargainFinderMax\Structs\ExchangeType
     */
    public function setOriginDestinationInformation(\Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType $originDestinationInformation = null)
    {
        $this->OriginDestinationInformation = $originDestinationInformation;
        return $this;
    }
    /**
     * Get Arunk value
     * @return \Sabre\BargainFinderMax\Structs\ArunkType|null
     */
    public function getArunk()
    {
        return $this->Arunk;
    }
    /**
     * Set Arunk value
     * @param \Sabre\BargainFinderMax\Structs\ArunkType $arunk
     * @return \Sabre\BargainFinderMax\Structs\ExchangeType
     */
    public function setArunk(\Sabre\BargainFinderMax\Structs\ArunkType $arunk = null)
    {
        $this->Arunk = $arunk;
        return $this;
    }
    /**
     * Get TravelPreferences value
     * @return \Sabre\BargainFinderMax\Structs\ExchangeAirSearchPrefsType|null
     */
    public function getTravelPreferences()
    {
        return $this->TravelPreferences;
    }
    /**
     * Set TravelPreferences value
     * @param \Sabre\BargainFinderMax\Structs\ExchangeAirSearchPrefsType $travelPreferences
     * @return \Sabre\BargainFinderMax\Structs\ExchangeType
     */
    public function setTravelPreferences(\Sabre\BargainFinderMax\Structs\ExchangeAirSearchPrefsType $travelPreferences = null)
    {
        $this->TravelPreferences = $travelPreferences;
        return $this;
    }
    /**
     * Get TravelerInfoSummary value
     * @return \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType|null
     */
    public function getTravelerInfoSummary()
    {
        return $this->TravelerInfoSummary;
    }
    /**
     * Set TravelerInfoSummary value
     * @param \Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType $travelerInfoSummary
     * @return \Sabre\BargainFinderMax\Structs\ExchangeType
     */
    public function setTravelerInfoSummary(\Sabre\BargainFinderMax\Structs\TravelerInfoSummaryType $travelerInfoSummary = null)
    {
        $this->TravelerInfoSummary = $travelerInfoSummary;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\ExchangeTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\ExchangeTPA_ExtensionsType $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\ExchangeType
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\ExchangeTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get OriginalTktIssueDateTime value
     * @return string|null
     */
    public function getOriginalTktIssueDateTime()
    {
        return $this->OriginalTktIssueDateTime;
    }
    /**
     * Set OriginalTktIssueDateTime value
     * @param string $originalTktIssueDateTime
     * @return \Sabre\BargainFinderMax\Structs\ExchangeType
     */
    public function setOriginalTktIssueDateTime($originalTktIssueDateTime = null)
    {
        $this->OriginalTktIssueDateTime = $originalTktIssueDateTime;
        return $this;
    }
    /**
     * Get ExchangedTktIssueDateTime value
     * @return string|null
     */
    public function getExchangedTktIssueDateTime()
    {
        return $this->ExchangedTktIssueDateTime;
    }
    /**
     * Set ExchangedTktIssueDateTime value
     * @param string $exchangedTktIssueDateTime
     * @return \Sabre\BargainFinderMax\Structs\ExchangeType
     */
    public function setExchangedTktIssueDateTime($exchangedTktIssueDateTime = null)
    {
        $this->ExchangedTktIssueDateTime = $exchangedTktIssueDateTime;
        return $this;
    }
    /**
     * Get PreviousExchangeDateTime value
     * @return string|null
     */
    public function getPreviousExchangeDateTime()
    {
        return $this->PreviousExchangeDateTime;
    }
    /**
     * Set PreviousExchangeDateTime value
     * @param string $previousExchangeDateTime
     * @return \Sabre\BargainFinderMax\Structs\ExchangeType
     */
    public function setPreviousExchangeDateTime($previousExchangeDateTime = null)
    {
        $this->PreviousExchangeDateTime = $previousExchangeDateTime;
        return $this;
    }
    /**
     * Get NumberOfTaxBoxes value
     * @return int|null
     */
    public function getNumberOfTaxBoxes()
    {
        return $this->NumberOfTaxBoxes;
    }
    /**
     * Set NumberOfTaxBoxes value
     * @param int $numberOfTaxBoxes
     * @return \Sabre\BargainFinderMax\Structs\ExchangeType
     */
    public function setNumberOfTaxBoxes($numberOfTaxBoxes = null)
    {
        $this->NumberOfTaxBoxes = $numberOfTaxBoxes;
        return $this;
    }
    /**
     * Get BypassAdvancePurchaseOption value
     * @return string|null
     */
    public function getBypassAdvancePurchaseOption()
    {
        return $this->BypassAdvancePurchaseOption;
    }
    /**
     * Set BypassAdvancePurchaseOption value
     * @param string $bypassAdvancePurchaseOption
     * @return \Sabre\BargainFinderMax\Structs\ExchangeType
     */
    public function setBypassAdvancePurchaseOption($bypassAdvancePurchaseOption = null)
    {
        $this->BypassAdvancePurchaseOption = $bypassAdvancePurchaseOption;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ExchangeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
