<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeTravelPreferencesTPA_ExtensionsType Structs
 * @subpackage Structs
 */
class ExchangeTravelPreferencesTPA_ExtensionsType extends AbstractStructBase
{
    /**
     * The ExemptAllTaxes
     * @var \Sabre\BargainFinderMax\Structs\ExemptAllTaxes
     */
    public $ExemptAllTaxes;
    /**
     * The ExemptAllTaxesAndFees
     * @var \Sabre\BargainFinderMax\Structs\ExemptAllTaxesAndFees
     */
    public $ExemptAllTaxesAndFees;
    /**
     * The Taxes
     * @var \Sabre\BargainFinderMax\Structs\Taxes
     */
    public $Taxes;
    /**
     * The ExemptTax
     * @var \Sabre\BargainFinderMax\Structs\TaxCodeType
     */
    public $ExemptTax;
    /**
     * The SettlementMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Overrides settlement method | Supported codes: BSP ARC TCH GEN (Generic TAT) RUT (Russian TAT) PRT (Philippines TAT) SAT (SATA) KRY (Killroy)
     * - length: 3
     * - pattern: [a-zA-Z0-9]{3}
     * @var string
     */
    public $SettlementMethod;
    /**
     * Constructor method for ExchangeTravelPreferencesTPA_ExtensionsType
     * @uses ExchangeTravelPreferencesTPA_ExtensionsType::setExemptAllTaxes()
     * @uses ExchangeTravelPreferencesTPA_ExtensionsType::setExemptAllTaxesAndFees()
     * @uses ExchangeTravelPreferencesTPA_ExtensionsType::setTaxes()
     * @uses ExchangeTravelPreferencesTPA_ExtensionsType::setExemptTax()
     * @uses ExchangeTravelPreferencesTPA_ExtensionsType::setSettlementMethod()
     * @param \Sabre\BargainFinderMax\Structs\ExemptAllTaxes $exemptAllTaxes
     * @param \Sabre\BargainFinderMax\Structs\ExemptAllTaxesAndFees $exemptAllTaxesAndFees
     * @param \Sabre\BargainFinderMax\Structs\Taxes $taxes
     * @param \Sabre\BargainFinderMax\Structs\TaxCodeType $exemptTax
     * @param string $settlementMethod
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\ExemptAllTaxes $exemptAllTaxes = null, \Sabre\BargainFinderMax\Structs\ExemptAllTaxesAndFees $exemptAllTaxesAndFees = null, \Sabre\BargainFinderMax\Structs\Taxes $taxes = null, \Sabre\BargainFinderMax\Structs\TaxCodeType $exemptTax = null, $settlementMethod = null)
    {
        $this
            ->setExemptAllTaxes($exemptAllTaxes)
            ->setExemptAllTaxesAndFees($exemptAllTaxesAndFees)
            ->setTaxes($taxes)
            ->setExemptTax($exemptTax)
            ->setSettlementMethod($settlementMethod);
    }
    /**
     * Get ExemptAllTaxes value
     * @return \Sabre\BargainFinderMax\Structs\ExemptAllTaxes|null
     */
    public function getExemptAllTaxes()
    {
        return $this->ExemptAllTaxes;
    }
    /**
     * Set ExemptAllTaxes value
     * @param \Sabre\BargainFinderMax\Structs\ExemptAllTaxes $exemptAllTaxes
     * @return \Sabre\BargainFinderMax\Structs\ExchangeTravelPreferencesTPA_ExtensionsType
     */
    public function setExemptAllTaxes(\Sabre\BargainFinderMax\Structs\ExemptAllTaxes $exemptAllTaxes = null)
    {
        $this->ExemptAllTaxes = $exemptAllTaxes;
        return $this;
    }
    /**
     * Get ExemptAllTaxesAndFees value
     * @return \Sabre\BargainFinderMax\Structs\ExemptAllTaxesAndFees|null
     */
    public function getExemptAllTaxesAndFees()
    {
        return $this->ExemptAllTaxesAndFees;
    }
    /**
     * Set ExemptAllTaxesAndFees value
     * @param \Sabre\BargainFinderMax\Structs\ExemptAllTaxesAndFees $exemptAllTaxesAndFees
     * @return \Sabre\BargainFinderMax\Structs\ExchangeTravelPreferencesTPA_ExtensionsType
     */
    public function setExemptAllTaxesAndFees(\Sabre\BargainFinderMax\Structs\ExemptAllTaxesAndFees $exemptAllTaxesAndFees = null)
    {
        $this->ExemptAllTaxesAndFees = $exemptAllTaxesAndFees;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \Sabre\BargainFinderMax\Structs\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \Sabre\BargainFinderMax\Structs\Taxes $taxes
     * @return \Sabre\BargainFinderMax\Structs\ExchangeTravelPreferencesTPA_ExtensionsType
     */
    public function setTaxes(\Sabre\BargainFinderMax\Structs\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get ExemptTax value
     * @return \Sabre\BargainFinderMax\Structs\TaxCodeType|null
     */
    public function getExemptTax()
    {
        return $this->ExemptTax;
    }
    /**
     * Set ExemptTax value
     * @param \Sabre\BargainFinderMax\Structs\TaxCodeType $exemptTax
     * @return \Sabre\BargainFinderMax\Structs\ExchangeTravelPreferencesTPA_ExtensionsType
     */
    public function setExemptTax(\Sabre\BargainFinderMax\Structs\TaxCodeType $exemptTax = null)
    {
        $this->ExemptTax = $exemptTax;
        return $this;
    }
    /**
     * Get SettlementMethod value
     * @return string|null
     */
    public function getSettlementMethod()
    {
        return $this->SettlementMethod;
    }
    /**
     * Set SettlementMethod value
     * @param string $settlementMethod
     * @return \Sabre\BargainFinderMax\Structs\ExchangeTravelPreferencesTPA_ExtensionsType
     */
    public function setSettlementMethod($settlementMethod = null)
    {
        $this->SettlementMethod = $settlementMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ExchangeTravelPreferencesTPA_ExtensionsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
