<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeSettingsType Structs
 * @subpackage Structs
 */
class ExchangeSettingsType extends AbstractStructBase
{
    /**
     * The RepriceCurrentItin
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: If set to ''false'', disables processing of Current Itin path.
     * - use: optional
     * @var bool
     */
    public $RepriceCurrentItin;
    /**
     * The AttachExchangeInfo
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: If set to ''true'', adds exchange-specific information to the response. The information includes richer Tax elements, ReissueVsExchange attribute and currency conversion rates.
     * - use: optional
     * @var bool
     */
    public $AttachExchangeInfo;
    /**
     * The ReissueExchange
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReissueExchange;
    /**
     * The BrandedResults
     * Meta informations extracted from the WSDL
     * - documentation: Enables branded results (if brands are available for returned options)
     * - use: optional
     * @var bool
     */
    public $BrandedResults;
    /**
     * The MIPTimeoutThreshold
     * Meta informations extracted from the WSDL
     * - documentation: Hints MIP that it should return options within this amount of time (in seconds)
     * - use: optional
     * @var int
     */
    public $MIPTimeoutThreshold;
    /**
     * The RequestType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RequestType;
    /**
     * Constructor method for ExchangeSettingsType
     * @uses ExchangeSettingsType::setRepriceCurrentItin()
     * @uses ExchangeSettingsType::setAttachExchangeInfo()
     * @uses ExchangeSettingsType::setReissueExchange()
     * @uses ExchangeSettingsType::setBrandedResults()
     * @uses ExchangeSettingsType::setMIPTimeoutThreshold()
     * @uses ExchangeSettingsType::setRequestType()
     * @param bool $repriceCurrentItin
     * @param bool $attachExchangeInfo
     * @param string $reissueExchange
     * @param bool $brandedResults
     * @param int $mIPTimeoutThreshold
     * @param string $requestType
     */
    public function __construct($repriceCurrentItin = true, $attachExchangeInfo = false, $reissueExchange = null, $brandedResults = null, $mIPTimeoutThreshold = null, $requestType = null)
    {
        $this
            ->setRepriceCurrentItin($repriceCurrentItin)
            ->setAttachExchangeInfo($attachExchangeInfo)
            ->setReissueExchange($reissueExchange)
            ->setBrandedResults($brandedResults)
            ->setMIPTimeoutThreshold($mIPTimeoutThreshold)
            ->setRequestType($requestType);
    }
    /**
     * Get RepriceCurrentItin value
     * @return bool|null
     */
    public function getRepriceCurrentItin()
    {
        return $this->RepriceCurrentItin;
    }
    /**
     * Set RepriceCurrentItin value
     * @param bool $repriceCurrentItin
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSettingsType
     */
    public function setRepriceCurrentItin($repriceCurrentItin = true)
    {
        $this->RepriceCurrentItin = $repriceCurrentItin;
        return $this;
    }
    /**
     * Get AttachExchangeInfo value
     * @return bool|null
     */
    public function getAttachExchangeInfo()
    {
        return $this->AttachExchangeInfo;
    }
    /**
     * Set AttachExchangeInfo value
     * @param bool $attachExchangeInfo
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSettingsType
     */
    public function setAttachExchangeInfo($attachExchangeInfo = false)
    {
        $this->AttachExchangeInfo = $attachExchangeInfo;
        return $this;
    }
    /**
     * Get ReissueExchange value
     * @return string|null
     */
    public function getReissueExchange()
    {
        return $this->ReissueExchange;
    }
    /**
     * Set ReissueExchange value
     * @param string $reissueExchange
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSettingsType
     */
    public function setReissueExchange($reissueExchange = null)
    {
        $this->ReissueExchange = $reissueExchange;
        return $this;
    }
    /**
     * Get BrandedResults value
     * @return bool|null
     */
    public function getBrandedResults()
    {
        return $this->BrandedResults;
    }
    /**
     * Set BrandedResults value
     * @param bool $brandedResults
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSettingsType
     */
    public function setBrandedResults($brandedResults = null)
    {
        $this->BrandedResults = $brandedResults;
        return $this;
    }
    /**
     * Get MIPTimeoutThreshold value
     * @return int|null
     */
    public function getMIPTimeoutThreshold()
    {
        return $this->MIPTimeoutThreshold;
    }
    /**
     * Set MIPTimeoutThreshold value
     * @param int $mIPTimeoutThreshold
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSettingsType
     */
    public function setMIPTimeoutThreshold($mIPTimeoutThreshold = null)
    {
        $this->MIPTimeoutThreshold = $mIPTimeoutThreshold;
        return $this;
    }
    /**
     * Get RequestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->RequestType;
    }
    /**
     * Set RequestType value
     * @param string $requestType
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSettingsType
     */
    public function setRequestType($requestType = null)
    {
        $this->RequestType = $requestType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSettingsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
