<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorsType Structs
 * Meta informations extracted from the WSDL
 * - documentation: A collection of errors that occurred during the processing of a message.
 * @subpackage Structs
 */
class ErrorsType extends AbstractStructBase
{
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - documentation: Describes an error that occurred during the processing of an OTA message
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\ErrorType[]
     */
    public $Error;
    /**
     * Constructor method for ErrorsType
     * @uses ErrorsType::setError()
     * @param \Sabre\BargainFinderMax\Structs\ErrorType[] $error
     */
    public function __construct(array $error = array())
    {
        $this
            ->setError($error);
    }
    /**
     * Get Error value
     * @return \Sabre\BargainFinderMax\Structs\ErrorType[]|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ErrorType[] $error
     * @return \Sabre\BargainFinderMax\Structs\ErrorsType
     */
    public function setError(array $error = array())
    {
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ErrorType $item
     * @return \Sabre\BargainFinderMax\Structs\ErrorsType
     */
    public function addToError(\Sabre\BargainFinderMax\Structs\ErrorType $item)
    {
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ErrorsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
