<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Equipment Structs
 * Meta informations extracted from the WSDL
 * - documentation: Equipment Information | Equipment type
 * @subpackage Structs
 */
class Equipment extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: Equipment Code | Air Equipment type
     * - pattern: [0-9A-Z]{1,4}
     * @var string
     */
    public $Code;
    /**
     * The Change
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Change Of Equipment
     * @var bool
     */
    public $Change;
    /**
     * The TypeForFirstLeg
     * @var string
     */
    public $TypeForFirstLeg;
    /**
     * The TypeForLastLeg
     * @var string
     */
    public $TypeForLastLeg;
    /**
     * Constructor method for Equipment
     * @uses Equipment::setCode()
     * @uses Equipment::setChange()
     * @uses Equipment::setTypeForFirstLeg()
     * @uses Equipment::setTypeForLastLeg()
     * @param string $code
     * @param bool $change
     * @param string $typeForFirstLeg
     * @param string $typeForLastLeg
     */
    public function __construct($code = null, $change = false, $typeForFirstLeg = null, $typeForLastLeg = null)
    {
        $this
            ->setCode($code)
            ->setChange($change)
            ->setTypeForFirstLeg($typeForFirstLeg)
            ->setTypeForLastLeg($typeForLastLeg);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\Equipment
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Change value
     * @return bool|null
     */
    public function getChange()
    {
        return $this->Change;
    }
    /**
     * Set Change value
     * @param bool $change
     * @return \Sabre\BargainFinderMax\Structs\Equipment
     */
    public function setChange($change = false)
    {
        $this->Change = $change;
        return $this;
    }
    /**
     * Get TypeForFirstLeg value
     * @return string|null
     */
    public function getTypeForFirstLeg()
    {
        return $this->TypeForFirstLeg;
    }
    /**
     * Set TypeForFirstLeg value
     * @param string $typeForFirstLeg
     * @return \Sabre\BargainFinderMax\Structs\Equipment
     */
    public function setTypeForFirstLeg($typeForFirstLeg = null)
    {
        $this->TypeForFirstLeg = $typeForFirstLeg;
        return $this;
    }
    /**
     * Get TypeForLastLeg value
     * @return string|null
     */
    public function getTypeForLastLeg()
    {
        return $this->TypeForLastLeg;
    }
    /**
     * Set TypeForLastLeg value
     * @param string $typeForLastLeg
     * @return \Sabre\BargainFinderMax\Structs\Equipment
     */
    public function setTypeForLastLeg($typeForLastLeg = null)
    {
        $this->TypeForLastLeg = $typeForLastLeg;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Equipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
