<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Destination Structs
 * @subpackage Structs
 */
class Destination extends AbstractStructBase
{
    /**
     * The ConnectionLocations
     * Meta informations extracted from the WSDL
     * - documentation: Travel Connection Location - for example, air uses the IATA 3 letter code.
     * - maxOccurs: 0
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ConnectionType
     */
    public $ConnectionLocations;
    /**
     * The Carriers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 0
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Carriers
     */
    public $Carriers;
    /**
     * The ArrivalDateTimeOverride
     * Meta informations extracted from the WSDL
     * - documentation: Overrides ArrivalDateTime attributes
     * - maxOccurs: 0
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\OverrideDateTimeType
     */
    public $ArrivalDateTimeOverride;
    /**
     * The AirportCode
     * Meta informations extracted from the WSDL
     * - documentation: Required unless AirportsGroup is specified. Cannot appear with AirportsGroup. | Used for Character Strings, length 1 to 8
     * - use: optional
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $AirportCode;
    /**
     * The AirportsGroup
     * Meta informations extracted from the WSDL
     * - documentation: Name of the airports group
     * @var string
     */
    public $AirportsGroup;
    /**
     * Constructor method for Destination
     * @uses Destination::setConnectionLocations()
     * @uses Destination::setCarriers()
     * @uses Destination::setArrivalDateTimeOverride()
     * @uses Destination::setAirportCode()
     * @uses Destination::setAirportsGroup()
     * @param \Sabre\BargainFinderMax\Structs\ConnectionType $connectionLocations
     * @param \Sabre\BargainFinderMax\Structs\Carriers $carriers
     * @param \Sabre\BargainFinderMax\Structs\OverrideDateTimeType $arrivalDateTimeOverride
     * @param string $airportCode
     * @param string $airportsGroup
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\ConnectionType $connectionLocations = null, \Sabre\BargainFinderMax\Structs\Carriers $carriers = null, \Sabre\BargainFinderMax\Structs\OverrideDateTimeType $arrivalDateTimeOverride = null, $airportCode = null, $airportsGroup = null)
    {
        $this
            ->setConnectionLocations($connectionLocations)
            ->setCarriers($carriers)
            ->setArrivalDateTimeOverride($arrivalDateTimeOverride)
            ->setAirportCode($airportCode)
            ->setAirportsGroup($airportsGroup);
    }
    /**
     * Get ConnectionLocations value
     * @return \Sabre\BargainFinderMax\Structs\ConnectionType|null
     */
    public function getConnectionLocations()
    {
        return $this->ConnectionLocations;
    }
    /**
     * Set ConnectionLocations value
     * @param \Sabre\BargainFinderMax\Structs\ConnectionType $connectionLocations
     * @return \Sabre\BargainFinderMax\Structs\Destination
     */
    public function setConnectionLocations(\Sabre\BargainFinderMax\Structs\ConnectionType $connectionLocations = null)
    {
        $this->ConnectionLocations = $connectionLocations;
        return $this;
    }
    /**
     * Get Carriers value
     * @return \Sabre\BargainFinderMax\Structs\Carriers|null
     */
    public function getCarriers()
    {
        return $this->Carriers;
    }
    /**
     * Set Carriers value
     * @param \Sabre\BargainFinderMax\Structs\Carriers $carriers
     * @return \Sabre\BargainFinderMax\Structs\Destination
     */
    public function setCarriers(\Sabre\BargainFinderMax\Structs\Carriers $carriers = null)
    {
        $this->Carriers = $carriers;
        return $this;
    }
    /**
     * Get ArrivalDateTimeOverride value
     * @return \Sabre\BargainFinderMax\Structs\OverrideDateTimeType|null
     */
    public function getArrivalDateTimeOverride()
    {
        return $this->ArrivalDateTimeOverride;
    }
    /**
     * Set ArrivalDateTimeOverride value
     * @param \Sabre\BargainFinderMax\Structs\OverrideDateTimeType $arrivalDateTimeOverride
     * @return \Sabre\BargainFinderMax\Structs\Destination
     */
    public function setArrivalDateTimeOverride(\Sabre\BargainFinderMax\Structs\OverrideDateTimeType $arrivalDateTimeOverride = null)
    {
        $this->ArrivalDateTimeOverride = $arrivalDateTimeOverride;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \Sabre\BargainFinderMax\Structs\Destination
     */
    public function setAirportCode($airportCode = null)
    {
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get AirportsGroup value
     * @return string|null
     */
    public function getAirportsGroup()
    {
        return $this->AirportsGroup;
    }
    /**
     * Set AirportsGroup value
     * @param string $airportsGroup
     * @return \Sabre\BargainFinderMax\Structs\Destination
     */
    public function setAirportsGroup($airportsGroup = null)
    {
        $this->AirportsGroup = $airportsGroup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Destination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
