<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepartureDates Structs
 * Meta informations extracted from the WSDL
 * - documentation: If both LengthOfStay (LengthOfStay, LengthOfStayRange) and Days (Day, DaysRange) tags are used, then as requested dates we are considering intersection between two groups of dates, first group is created by sum of dates specified in
 * Day and DaysRange tags, second group is created by LengthOfStay and LengthOfStayRange Example: outbound departing on 2014 Jan 20 and inbound with: LengthOfStayRange/@MinDays="1", LengthOfStayRange/@MaxDays="3", DaysRange/@FromDate="2014-01-22",
 * DaysRange/@ToDate="2014-01-24" after intersection gave us inbound departing range: [ 2014-01-22 ; 2014-01-23 ]
 * @subpackage Structs
 */
class DepartureDates extends AbstractStructBase
{
    /**
     * The Day
     * @var \Sabre\BargainFinderMax\Structs\Day
     */
    public $Day;
    /**
     * The DaysRange
     * @var \Sabre\BargainFinderMax\Structs\DaysRange
     */
    public $DaysRange;
    /**
     * The LengthOfStay
     * @var \Sabre\BargainFinderMax\Structs\LengthOfStay
     */
    public $LengthOfStay;
    /**
     * The LengthOfStayRange
     * @var \Sabre\BargainFinderMax\Structs\LengthOfStayRange
     */
    public $LengthOfStayRange;
    /**
     * Constructor method for DepartureDates
     * @uses DepartureDates::setDay()
     * @uses DepartureDates::setDaysRange()
     * @uses DepartureDates::setLengthOfStay()
     * @uses DepartureDates::setLengthOfStayRange()
     * @param \Sabre\BargainFinderMax\Structs\Day $day
     * @param \Sabre\BargainFinderMax\Structs\DaysRange $daysRange
     * @param \Sabre\BargainFinderMax\Structs\LengthOfStay $lengthOfStay
     * @param \Sabre\BargainFinderMax\Structs\LengthOfStayRange $lengthOfStayRange
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\Day $day = null, \Sabre\BargainFinderMax\Structs\DaysRange $daysRange = null, \Sabre\BargainFinderMax\Structs\LengthOfStay $lengthOfStay = null, \Sabre\BargainFinderMax\Structs\LengthOfStayRange $lengthOfStayRange = null)
    {
        $this
            ->setDay($day)
            ->setDaysRange($daysRange)
            ->setLengthOfStay($lengthOfStay)
            ->setLengthOfStayRange($lengthOfStayRange);
    }
    /**
     * Get Day value
     * @return \Sabre\BargainFinderMax\Structs\Day|null
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @param \Sabre\BargainFinderMax\Structs\Day $day
     * @return \Sabre\BargainFinderMax\Structs\DepartureDates
     */
    public function setDay(\Sabre\BargainFinderMax\Structs\Day $day = null)
    {
        $this->Day = $day;
        return $this;
    }
    /**
     * Get DaysRange value
     * @return \Sabre\BargainFinderMax\Structs\DaysRange|null
     */
    public function getDaysRange()
    {
        return $this->DaysRange;
    }
    /**
     * Set DaysRange value
     * @param \Sabre\BargainFinderMax\Structs\DaysRange $daysRange
     * @return \Sabre\BargainFinderMax\Structs\DepartureDates
     */
    public function setDaysRange(\Sabre\BargainFinderMax\Structs\DaysRange $daysRange = null)
    {
        $this->DaysRange = $daysRange;
        return $this;
    }
    /**
     * Get LengthOfStay value
     * @return \Sabre\BargainFinderMax\Structs\LengthOfStay|null
     */
    public function getLengthOfStay()
    {
        return $this->LengthOfStay;
    }
    /**
     * Set LengthOfStay value
     * @param \Sabre\BargainFinderMax\Structs\LengthOfStay $lengthOfStay
     * @return \Sabre\BargainFinderMax\Structs\DepartureDates
     */
    public function setLengthOfStay(\Sabre\BargainFinderMax\Structs\LengthOfStay $lengthOfStay = null)
    {
        $this->LengthOfStay = $lengthOfStay;
        return $this;
    }
    /**
     * Get LengthOfStayRange value
     * @return \Sabre\BargainFinderMax\Structs\LengthOfStayRange|null
     */
    public function getLengthOfStayRange()
    {
        return $this->LengthOfStayRange;
    }
    /**
     * Set LengthOfStayRange value
     * @param \Sabre\BargainFinderMax\Structs\LengthOfStayRange $lengthOfStayRange
     * @return \Sabre\BargainFinderMax\Structs\DepartureDates
     */
    public function setLengthOfStayRange(\Sabre\BargainFinderMax\Structs\LengthOfStayRange $lengthOfStayRange = null)
    {
        $this->LengthOfStayRange = $lengthOfStayRange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\DepartureDates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
