<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateFlexibility Structs
 * Meta informations extracted from the WSDL
 * - documentation: The number of alternate days around the travel date to search.
 * - maxOccurs: 2
 * - minOccurs: 0
 * @subpackage Structs
 */
class DateFlexibility extends AbstractStructBase
{
    /**
     * The NbrOfDays
     * Meta informations extracted from the WSDL
     * - documentation: Number of alternate dates before and after requested travel date.
     * - use: optional
     * @var int
     */
    public $NbrOfDays;
    /**
     * The Plus
     * Meta informations extracted from the WSDL
     * - documentation: Number of alternate dates before requested travel date.
     * - use: optional
     * @var int
     */
    public $Plus;
    /**
     * The Minus
     * Meta informations extracted from the WSDL
     * - documentation: Number of alternate dates after requested travel date.
     * - use: optional
     * @var int
     */
    public $Minus;
    /**
     * The Validate
     * Meta informations extracted from the WSDL
     * - documentation: Flag telling if dates within the specified range should be processed in the validate path.
     * - use: optional
     * @var bool
     */
    public $Validate;
    /**
     * Constructor method for DateFlexibility
     * @uses DateFlexibility::setNbrOfDays()
     * @uses DateFlexibility::setPlus()
     * @uses DateFlexibility::setMinus()
     * @uses DateFlexibility::setValidate()
     * @param int $nbrOfDays
     * @param int $plus
     * @param int $minus
     * @param bool $validate
     */
    public function __construct($nbrOfDays = null, $plus = null, $minus = null, $validate = null)
    {
        $this
            ->setNbrOfDays($nbrOfDays)
            ->setPlus($plus)
            ->setMinus($minus)
            ->setValidate($validate);
    }
    /**
     * Get NbrOfDays value
     * @return int|null
     */
    public function getNbrOfDays()
    {
        return $this->NbrOfDays;
    }
    /**
     * Set NbrOfDays value
     * @param int $nbrOfDays
     * @return \Sabre\BargainFinderMax\Structs\DateFlexibility
     */
    public function setNbrOfDays($nbrOfDays = null)
    {
        $this->NbrOfDays = $nbrOfDays;
        return $this;
    }
    /**
     * Get Plus value
     * @return int|null
     */
    public function getPlus()
    {
        return $this->Plus;
    }
    /**
     * Set Plus value
     * @param int $plus
     * @return \Sabre\BargainFinderMax\Structs\DateFlexibility
     */
    public function setPlus($plus = null)
    {
        $this->Plus = $plus;
        return $this;
    }
    /**
     * Get Minus value
     * @return int|null
     */
    public function getMinus()
    {
        return $this->Minus;
    }
    /**
     * Set Minus value
     * @param int $minus
     * @return \Sabre\BargainFinderMax\Structs\DateFlexibility
     */
    public function setMinus($minus = null)
    {
        $this->Minus = $minus;
        return $this;
    }
    /**
     * Get Validate value
     * @return bool|null
     */
    public function getValidate()
    {
        return $this->Validate;
    }
    /**
     * Set Validate value
     * @param bool $validate
     * @return \Sabre\BargainFinderMax\Structs\DateFlexibility
     */
    public function setValidate($validate = null)
    {
        $this->Validate = $validate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\DateFlexibility
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
