<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountryPref Structs
 * Meta informations extracted from the WSDL
 * - documentation: List of countries to be excluded from processing
 * @subpackage Structs
 */
class CountryPref extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: 2 character country code as defined in ISO3166.
     * - pattern: [a-zA-Z]{2}
     * @var string
     */
    public $Code;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for CountryPref
     * @uses CountryPref::setCode()
     * @uses CountryPref::setPreferLevel()
     * @param string $code
     * @param string $preferLevel
     */
    public function __construct($code = null, $preferLevel = null)
    {
        $this
            ->setCode($code)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\CountryPref
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @param string $preferLevel
     * @return \Sabre\BargainFinderMax\Structs\CountryPref
     */
    public function setPreferLevel($preferLevel = null)
    {
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\CountryPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
