<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionTime Structs
 * Meta informations extracted from the WSDL
 * - documentation: Prefer itineraries with smaller amount of time waiting in the airports during connections | Connection time between segments.
 * - minOccurs: 0
 * @subpackage Structs
 */
class ConnectionTime extends AbstractStructBase
{
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxInclusive: 9
     * - minInclusive: 1
     * @var int
     */
    public $Priority;
    /**
     * The Leg
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Leg;
    /**
     * The Min
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Min;
    /**
     * The Max
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Max;
    /**
     * The ExcludedConnectionBegin
     * Meta informations extracted from the WSDL
     * - documentation: Excluded connection time begin in format HHMM | IntelliSell Time Window Boundary type in format HHMM.
     * - use: optional
     * - pattern: ([0-1][0-9]|2[0-3])[0-5][0-9]
     * @var string
     */
    public $ExcludedConnectionBegin;
    /**
     * The ExcludedConnectionEnd
     * Meta informations extracted from the WSDL
     * - documentation: Excluded connection time end in format HHMM | IntelliSell Time Window Boundary type in format HHMM.
     * - use: optional
     * - pattern: ([0-1][0-9]|2[0-3])[0-5][0-9]
     * @var string
     */
    public $ExcludedConnectionEnd;
    /**
     * The EnableExcludedConnection
     * Meta informations extracted from the WSDL
     * - documentation: Enable excluded connection time (default: true)
     * - use: optional
     * @var bool
     */
    public $EnableExcludedConnection;
    /**
     * Constructor method for ConnectionTime
     * @uses ConnectionTime::setPriority()
     * @uses ConnectionTime::setLeg()
     * @uses ConnectionTime::setMin()
     * @uses ConnectionTime::setMax()
     * @uses ConnectionTime::setExcludedConnectionBegin()
     * @uses ConnectionTime::setExcludedConnectionEnd()
     * @uses ConnectionTime::setEnableExcludedConnection()
     * @param int $priority
     * @param int $leg
     * @param int $min
     * @param int $max
     * @param string $excludedConnectionBegin
     * @param string $excludedConnectionEnd
     * @param bool $enableExcludedConnection
     */
    public function __construct($priority = null, $leg = null, $min = null, $max = null, $excludedConnectionBegin = null, $excludedConnectionEnd = null, $enableExcludedConnection = null)
    {
        $this
            ->setPriority($priority)
            ->setLeg($leg)
            ->setMin($min)
            ->setMax($max)
            ->setExcludedConnectionBegin($excludedConnectionBegin)
            ->setExcludedConnectionEnd($excludedConnectionEnd)
            ->setEnableExcludedConnection($enableExcludedConnection);
    }
    /**
     * Get Priority value
     * @return int
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \Sabre\BargainFinderMax\Structs\ConnectionTime
     */
    public function setPriority($priority = null)
    {
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Leg value
     * @return int|null
     */
    public function getLeg()
    {
        return $this->Leg;
    }
    /**
     * Set Leg value
     * @param int $leg
     * @return \Sabre\BargainFinderMax\Structs\ConnectionTime
     */
    public function setLeg($leg = null)
    {
        $this->Leg = $leg;
        return $this;
    }
    /**
     * Get Min value
     * @return int|null
     */
    public function getMin()
    {
        return $this->Min;
    }
    /**
     * Set Min value
     * @param int $min
     * @return \Sabre\BargainFinderMax\Structs\ConnectionTime
     */
    public function setMin($min = null)
    {
        $this->Min = $min;
        return $this;
    }
    /**
     * Get Max value
     * @return int|null
     */
    public function getMax()
    {
        return $this->Max;
    }
    /**
     * Set Max value
     * @param int $max
     * @return \Sabre\BargainFinderMax\Structs\ConnectionTime
     */
    public function setMax($max = null)
    {
        $this->Max = $max;
        return $this;
    }
    /**
     * Get ExcludedConnectionBegin value
     * @return string|null
     */
    public function getExcludedConnectionBegin()
    {
        return $this->ExcludedConnectionBegin;
    }
    /**
     * Set ExcludedConnectionBegin value
     * @param string $excludedConnectionBegin
     * @return \Sabre\BargainFinderMax\Structs\ConnectionTime
     */
    public function setExcludedConnectionBegin($excludedConnectionBegin = null)
    {
        $this->ExcludedConnectionBegin = $excludedConnectionBegin;
        return $this;
    }
    /**
     * Get ExcludedConnectionEnd value
     * @return string|null
     */
    public function getExcludedConnectionEnd()
    {
        return $this->ExcludedConnectionEnd;
    }
    /**
     * Set ExcludedConnectionEnd value
     * @param string $excludedConnectionEnd
     * @return \Sabre\BargainFinderMax\Structs\ConnectionTime
     */
    public function setExcludedConnectionEnd($excludedConnectionEnd = null)
    {
        $this->ExcludedConnectionEnd = $excludedConnectionEnd;
        return $this;
    }
    /**
     * Get EnableExcludedConnection value
     * @return bool|null
     */
    public function getEnableExcludedConnection()
    {
        return $this->EnableExcludedConnection;
    }
    /**
     * Set EnableExcludedConnection value
     * @param bool $enableExcludedConnection
     * @return \Sabre\BargainFinderMax\Structs\ConnectionTime
     */
    public function setEnableExcludedConnection($enableExcludedConnection = null)
    {
        $this->EnableExcludedConnection = $enableExcludedConnection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ConnectionTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
