<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyNameType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Identifies a company by name.
 * @subpackage Structs
 */
class CompanyNameType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The CompanyShortName
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 64
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $CompanyShortName;
    /**
     * The TravelSector
     * Meta informations extracted from the WSDL
     * - documentation: Refer to OTA Code List Travel Sector (TVS). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * @var string
     */
    public $TravelSector;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: Identifies a company by the company code. | Used for Character Strings, length 1 to 8
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the context of the identifying code, such as DUNS, IATA or internal code, etc. | Used for Character Strings, length 1 to 32
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CodeContext;
    /**
     * Constructor method for CompanyNameType
     * @uses CompanyNameType::set_()
     * @uses CompanyNameType::setCompanyShortName()
     * @uses CompanyNameType::setTravelSector()
     * @uses CompanyNameType::setCode()
     * @uses CompanyNameType::setCodeContext()
     * @param string $_
     * @param string $companyShortName
     * @param string $travelSector
     * @param string $code
     * @param string $codeContext
     */
    public function __construct($_ = null, $companyShortName = null, $travelSector = null, $code = null, $codeContext = null)
    {
        $this
            ->set_($_)
            ->setCompanyShortName($companyShortName)
            ->setTravelSector($travelSector)
            ->setCode($code)
            ->setCodeContext($codeContext);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\BargainFinderMax\Structs\CompanyNameType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get CompanyShortName value
     * @return string|null
     */
    public function getCompanyShortName()
    {
        return $this->CompanyShortName;
    }
    /**
     * Set CompanyShortName value
     * @param string $companyShortName
     * @return \Sabre\BargainFinderMax\Structs\CompanyNameType
     */
    public function setCompanyShortName($companyShortName = null)
    {
        $this->CompanyShortName = $companyShortName;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \Sabre\BargainFinderMax\Structs\CompanyNameType
     */
    public function setTravelSector($travelSector = null)
    {
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\CompanyNameType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \Sabre\BargainFinderMax\Structs\CompanyNameType
     */
    public function setCodeContext($codeContext = null)
    {
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\CompanyNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
