<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeFeeType Structs
 * @subpackage Structs
 */
class ChangeFeeType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Change Fee Amount
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - documentation: Change Fee Currency | Currency Code type
     * - use: required | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $Currency;
    /**
     * The Waived
     * Meta informations extracted from the WSDL
     * - documentation: Change Fee Waived
     * - use: optional
     * @var bool
     */
    public $Waived;
    /**
     * The NotApplicable
     * Meta informations extracted from the WSDL
     * - documentation: Change Fee Not Applicable
     * - use: optional
     * @var bool
     */
    public $NotApplicable;
    /**
     * The Highest
     * Meta informations extracted from the WSDL
     * - documentation: Highest Change Fee Indicator
     * - use: optional
     * @var bool
     */
    public $Highest;
    /**
     * Constructor method for ChangeFeeType
     * @uses ChangeFeeType::setAmount()
     * @uses ChangeFeeType::setCurrency()
     * @uses ChangeFeeType::setWaived()
     * @uses ChangeFeeType::setNotApplicable()
     * @uses ChangeFeeType::setHighest()
     * @param float $amount
     * @param string $currency
     * @param bool $waived
     * @param bool $notApplicable
     * @param bool $highest
     */
    public function __construct($amount = null, $currency = null, $waived = null, $notApplicable = null, $highest = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setWaived($waived)
            ->setNotApplicable($notApplicable)
            ->setHighest($highest);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\BargainFinderMax\Structs\ChangeFeeType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Sabre\BargainFinderMax\Structs\ChangeFeeType
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Waived value
     * @return bool|null
     */
    public function getWaived()
    {
        return $this->Waived;
    }
    /**
     * Set Waived value
     * @param bool $waived
     * @return \Sabre\BargainFinderMax\Structs\ChangeFeeType
     */
    public function setWaived($waived = null)
    {
        $this->Waived = $waived;
        return $this;
    }
    /**
     * Get NotApplicable value
     * @return bool|null
     */
    public function getNotApplicable()
    {
        return $this->NotApplicable;
    }
    /**
     * Set NotApplicable value
     * @param bool $notApplicable
     * @return \Sabre\BargainFinderMax\Structs\ChangeFeeType
     */
    public function setNotApplicable($notApplicable = null)
    {
        $this->NotApplicable = $notApplicable;
        return $this;
    }
    /**
     * Get Highest value
     * @return bool|null
     */
    public function getHighest()
    {
        return $this->Highest;
    }
    /**
     * Set Highest value
     * @param bool $highest
     * @return \Sabre\BargainFinderMax\Structs\ChangeFeeType
     */
    public function setHighest($highest = null)
    {
        $this->Highest = $highest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ChangeFeeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
