<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Carriers Structs
 * Meta informations extracted from the WSDL
 * - documentation: Carrier preferrence information | Carrier preferrence information | Carrier preferrence information
 * @subpackage Structs
 */
class Carriers extends AbstractStructBase
{
    /**
     * The IncludeVendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\IncludeVendorPrefType[]
     */
    public $IncludeVendorPref;
    /**
     * The ExcludeVendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\ExcludeVendorPref[]
     */
    public $ExcludeVendorPref;
    /**
     * Constructor method for Carriers
     * @uses Carriers::setIncludeVendorPref()
     * @uses Carriers::setExcludeVendorPref()
     * @param \Sabre\BargainFinderMax\Structs\IncludeVendorPrefType[] $includeVendorPref
     * @param \Sabre\BargainFinderMax\Structs\ExcludeVendorPref[] $excludeVendorPref
     */
    public function __construct(array $includeVendorPref = array(), array $excludeVendorPref = array())
    {
        $this
            ->setIncludeVendorPref($includeVendorPref)
            ->setExcludeVendorPref($excludeVendorPref);
    }
    /**
     * Get IncludeVendorPref value
     * @return \Sabre\BargainFinderMax\Structs\IncludeVendorPrefType[]|null
     */
    public function getIncludeVendorPref()
    {
        return $this->IncludeVendorPref;
    }
    /**
     * Set IncludeVendorPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\IncludeVendorPrefType[] $includeVendorPref
     * @return \Sabre\BargainFinderMax\Structs\Carriers
     */
    public function setIncludeVendorPref(array $includeVendorPref = array())
    {
        $this->IncludeVendorPref = $includeVendorPref;
        return $this;
    }
    /**
     * Add item to IncludeVendorPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\IncludeVendorPrefType $item
     * @return \Sabre\BargainFinderMax\Structs\Carriers
     */
    public function addToIncludeVendorPref(\Sabre\BargainFinderMax\Structs\IncludeVendorPrefType $item)
    {
        $this->IncludeVendorPref[] = $item;
        return $this;
    }
    /**
     * Get ExcludeVendorPref value
     * @return \Sabre\BargainFinderMax\Structs\ExcludeVendorPref[]|null
     */
    public function getExcludeVendorPref()
    {
        return $this->ExcludeVendorPref;
    }
    /**
     * Set ExcludeVendorPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ExcludeVendorPref[] $excludeVendorPref
     * @return \Sabre\BargainFinderMax\Structs\Carriers
     */
    public function setExcludeVendorPref(array $excludeVendorPref = array())
    {
        $this->ExcludeVendorPref = $excludeVendorPref;
        return $this;
    }
    /**
     * Add item to ExcludeVendorPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ExcludeVendorPref $item
     * @return \Sabre\BargainFinderMax\Structs\Carriers
     */
    public function addToExcludeVendorPref(\Sabre\BargainFinderMax\Structs\ExcludeVendorPref $item)
    {
        $this->ExcludeVendorPref[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Carriers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
