<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cached Structs
 * Meta informations extracted from the WSDL
 * - documentation: Indicates whether the itin is from Cache. If this element exists, itin is from Cache.
 * @subpackage Structs
 */
class Cached extends AbstractStructBase
{
    /**
     * The Ref
     * Meta informations extracted from the WSDL
     * - documentation: Reference to Cache Source descryption ID
     * - use: required
     * @var int
     */
    public $Ref;
    /**
     * The TimeToLive
     * Meta informations extracted from the WSDL
     * - documentation: Time to live in cache (in minutes).
     * @var int
     */
    public $TimeToLive;
    /**
     * The HoursSinceCreation
     * Meta informations extracted from the WSDL
     * - documentation: Hours since option was created and stored in cache (in hours).
     * @var int
     */
    public $HoursSinceCreation;
    /**
     * The Voided
     * @var string
     */
    public $Voided;
    /**
     * Constructor method for Cached
     * @uses Cached::setRef()
     * @uses Cached::setTimeToLive()
     * @uses Cached::setHoursSinceCreation()
     * @uses Cached::setVoided()
     * @param int $ref
     * @param int $timeToLive
     * @param int $hoursSinceCreation
     * @param string $voided
     */
    public function __construct($ref = null, $timeToLive = null, $hoursSinceCreation = null, $voided = null)
    {
        $this
            ->setRef($ref)
            ->setTimeToLive($timeToLive)
            ->setHoursSinceCreation($hoursSinceCreation)
            ->setVoided($voided);
    }
    /**
     * Get Ref value
     * @return int
     */
    public function getRef()
    {
        return $this->Ref;
    }
    /**
     * Set Ref value
     * @param int $ref
     * @return \Sabre\BargainFinderMax\Structs\Cached
     */
    public function setRef($ref = null)
    {
        $this->Ref = $ref;
        return $this;
    }
    /**
     * Get TimeToLive value
     * @return int|null
     */
    public function getTimeToLive()
    {
        return $this->TimeToLive;
    }
    /**
     * Set TimeToLive value
     * @param int $timeToLive
     * @return \Sabre\BargainFinderMax\Structs\Cached
     */
    public function setTimeToLive($timeToLive = null)
    {
        $this->TimeToLive = $timeToLive;
        return $this;
    }
    /**
     * Get HoursSinceCreation value
     * @return int|null
     */
    public function getHoursSinceCreation()
    {
        return $this->HoursSinceCreation;
    }
    /**
     * Set HoursSinceCreation value
     * @param int $hoursSinceCreation
     * @return \Sabre\BargainFinderMax\Structs\Cached
     */
    public function setHoursSinceCreation($hoursSinceCreation = null)
    {
        $this->HoursSinceCreation = $hoursSinceCreation;
        return $this;
    }
    /**
     * Get Voided value
     * @return string|null
     */
    public function getVoided()
    {
        return $this->Voided;
    }
    /**
     * Set Voided value
     * @param string $voided
     * @return \Sabre\BargainFinderMax\Structs\Cached
     */
    public function setVoided($voided = null)
    {
        $this->Voided = $voided;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Cached
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
