<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CachePartitionGroupType Structs
 * @subpackage Structs
 */
class CachePartitionGroupType extends AbstractStructBase
{
    /**
     * The Partition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 2
     * @var \Sabre\BargainFinderMax\Structs\CachePartitionType[]
     */
    public $Partition;
    /**
     * Constructor method for CachePartitionGroupType
     * @uses CachePartitionGroupType::setPartition()
     * @param \Sabre\BargainFinderMax\Structs\CachePartitionType[] $partition
     */
    public function __construct(array $partition = array())
    {
        $this
            ->setPartition($partition);
    }
    /**
     * Get Partition value
     * @return \Sabre\BargainFinderMax\Structs\CachePartitionType[]
     */
    public function getPartition()
    {
        return $this->Partition;
    }
    /**
     * Set Partition value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CachePartitionType[] $partition
     * @return \Sabre\BargainFinderMax\Structs\CachePartitionGroupType
     */
    public function setPartition(array $partition = array())
    {
        $this->Partition = $partition;
        return $this;
    }
    /**
     * Add item to Partition value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CachePartitionType $item
     * @return \Sabre\BargainFinderMax\Structs\CachePartitionGroupType
     */
    public function addToPartition(\Sabre\BargainFinderMax\Structs\CachePartitionType $item)
    {
        $this->Partition[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\CachePartitionGroupType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
