<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Budget Structs
 * Meta informations extracted from the WSDL
 * - documentation: Budget Shopping settings
 * @subpackage Structs
 */
class Budget extends AbstractStructBase
{
    /**
     * The MinimumPrice
     * @var string
     */
    public $MinimumPrice;
    /**
     * The MaximumPrice
     * @var string
     */
    public $MaximumPrice;
    /**
     * The RelativePriceThreshold
     * Meta informations extracted from the WSDL
     * - documentation: Relative price difference threshold to be respected while choosing alternative options
     * - pattern: 0|-?[1-9][0-9]*%?
     * @var string
     */
    public $RelativePriceThreshold;
    /**
     * Constructor method for Budget
     * @uses Budget::setMinimumPrice()
     * @uses Budget::setMaximumPrice()
     * @uses Budget::setRelativePriceThreshold()
     * @param string $minimumPrice
     * @param string $maximumPrice
     * @param string $relativePriceThreshold
     */
    public function __construct($minimumPrice = null, $maximumPrice = null, $relativePriceThreshold = null)
    {
        $this
            ->setMinimumPrice($minimumPrice)
            ->setMaximumPrice($maximumPrice)
            ->setRelativePriceThreshold($relativePriceThreshold);
    }
    /**
     * Get MinimumPrice value
     * @return string|null
     */
    public function getMinimumPrice()
    {
        return $this->MinimumPrice;
    }
    /**
     * Set MinimumPrice value
     * @param string $minimumPrice
     * @return \Sabre\BargainFinderMax\Structs\Budget
     */
    public function setMinimumPrice($minimumPrice = null)
    {
        $this->MinimumPrice = $minimumPrice;
        return $this;
    }
    /**
     * Get MaximumPrice value
     * @return string|null
     */
    public function getMaximumPrice()
    {
        return $this->MaximumPrice;
    }
    /**
     * Set MaximumPrice value
     * @param string $maximumPrice
     * @return \Sabre\BargainFinderMax\Structs\Budget
     */
    public function setMaximumPrice($maximumPrice = null)
    {
        $this->MaximumPrice = $maximumPrice;
        return $this;
    }
    /**
     * Get RelativePriceThreshold value
     * @return string|null
     */
    public function getRelativePriceThreshold()
    {
        return $this->RelativePriceThreshold;
    }
    /**
     * Set RelativePriceThreshold value
     * @param string $relativePriceThreshold
     * @return \Sabre\BargainFinderMax\Structs\Budget
     */
    public function setRelativePriceThreshold($relativePriceThreshold = null)
    {
        $this->RelativePriceThreshold = $relativePriceThreshold;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Budget
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
