<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BrandType Structs
 * @subpackage Structs
 */
class BrandType extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: Brand code
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The BrandName
     * Meta informations extracted from the WSDL
     * - documentation: Brand name
     * - use: optional
     * @var string
     */
    public $BrandName;
    /**
     * The ProgramID
     * Meta informations extracted from the WSDL
     * - documentation: Program ID
     * - use: optional
     * @var string
     */
    public $ProgramID;
    /**
     * The ProgramCode
     * Meta informations extracted from the WSDL
     * - documentation: Program Code
     * - use: optional
     * @var string
     */
    public $ProgramCode;
    /**
     * The ProgramDescription
     * Meta informations extracted from the WSDL
     * - documentation: Program Description
     * - use: optional
     * @var string
     */
    public $ProgramDescription;
    /**
     * The ProgramSystemCode
     * Meta informations extracted from the WSDL
     * - documentation: Program System Code
     * - use: optional
     * @var string
     */
    public $ProgramSystemCode;
    /**
     * Constructor method for BrandType
     * @uses BrandType::setCode()
     * @uses BrandType::setBrandName()
     * @uses BrandType::setProgramID()
     * @uses BrandType::setProgramCode()
     * @uses BrandType::setProgramDescription()
     * @uses BrandType::setProgramSystemCode()
     * @param string $code
     * @param string $brandName
     * @param string $programID
     * @param string $programCode
     * @param string $programDescription
     * @param string $programSystemCode
     */
    public function __construct($code = null, $brandName = null, $programID = null, $programCode = null, $programDescription = null, $programSystemCode = null)
    {
        $this
            ->setCode($code)
            ->setBrandName($brandName)
            ->setProgramID($programID)
            ->setProgramCode($programCode)
            ->setProgramDescription($programDescription)
            ->setProgramSystemCode($programSystemCode);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\BrandType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \Sabre\BargainFinderMax\Structs\BrandType
     */
    public function setBrandName($brandName = null)
    {
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \Sabre\BargainFinderMax\Structs\BrandType
     */
    public function setProgramID($programID = null)
    {
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \Sabre\BargainFinderMax\Structs\BrandType
     */
    public function setProgramCode($programCode = null)
    {
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get ProgramDescription value
     * @return string|null
     */
    public function getProgramDescription()
    {
        return $this->ProgramDescription;
    }
    /**
     * Set ProgramDescription value
     * @param string $programDescription
     * @return \Sabre\BargainFinderMax\Structs\BrandType
     */
    public function setProgramDescription($programDescription = null)
    {
        $this->ProgramDescription = $programDescription;
        return $this;
    }
    /**
     * Get ProgramSystemCode value
     * @return string|null
     */
    public function getProgramSystemCode()
    {
        return $this->ProgramSystemCode;
    }
    /**
     * Set ProgramSystemCode value
     * @param string $programSystemCode
     * @return \Sabre\BargainFinderMax\Structs\BrandType
     */
    public function setProgramSystemCode($programSystemCode = null)
    {
        $this->ProgramSystemCode = $programSystemCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\BrandType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
