<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BrandFeatureType Structs
 * Meta informations extracted from the WSDL
 * - documentation: ATPCO Table 166 brand feature item | ATPCO Table 166 brand feature item
 * @subpackage Structs
 */
class BrandFeatureType extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Reference ID
     * - use: required
     * @var int
     */
    public $Id;
    /**
     * The Application
     * Meta informations extracted from the WSDL
     * - documentation: Indicates if the service is free (F), not offered (N), chargeable (C), or displayed but not offered (D). | Used for Characters, length 1 | Used for Characters, length 1
     * - use: required
     * - length: 1
     * @var string
     */
    public $Application;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Used for Characters, length 1 | Used for Characters, length 1
     * - length: 1
     * @var string
     */
    public $ServiceType;
    /**
     * The ServiceGroup
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ServiceGroup;
    /**
     * The SubCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SubCode;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Vendor;
    /**
     * The CommercialName
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CommercialName;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Reference ID
     * - use: required
     * @var int
     */
    public $ID;
    /**
     * Constructor method for BrandFeatureType
     * @uses BrandFeatureType::setId()
     * @uses BrandFeatureType::setApplication()
     * @uses BrandFeatureType::setServiceType()
     * @uses BrandFeatureType::setServiceGroup()
     * @uses BrandFeatureType::setSubCode()
     * @uses BrandFeatureType::setVendor()
     * @uses BrandFeatureType::setCommercialName()
     * @uses BrandFeatureType::setID_1()
     * @param int $id
     * @param string $application
     * @param string $serviceType
     * @param string $serviceGroup
     * @param string $subCode
     * @param string $vendor
     * @param string $commercialName
     * @param int $iD
     */
    public function __construct($id = null, $application = null, $serviceType = null, $serviceGroup = null, $subCode = null, $vendor = null, $commercialName = null, $iD = null)
    {
        $this
            ->setId($id)
            ->setApplication($application)
            ->setServiceType($serviceType)
            ->setServiceGroup($serviceGroup)
            ->setSubCode($subCode)
            ->setVendor($vendor)
            ->setCommercialName($commercialName)
            ->setID_1($iD);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Application value
     * @return string
     */
    public function getApplication()
    {
        return $this->Application;
    }
    /**
     * Set Application value
     * @param string $application
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureType
     */
    public function setApplication($application = null)
    {
        $this->Application = $application;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return string
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param string $serviceType
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureType
     */
    public function setServiceType($serviceType = null)
    {
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get ServiceGroup value
     * @return string
     */
    public function getServiceGroup()
    {
        return $this->ServiceGroup;
    }
    /**
     * Set ServiceGroup value
     * @param string $serviceGroup
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureType
     */
    public function setServiceGroup($serviceGroup = null)
    {
        $this->ServiceGroup = $serviceGroup;
        return $this;
    }
    /**
     * Get SubCode value
     * @return string
     */
    public function getSubCode()
    {
        return $this->SubCode;
    }
    /**
     * Set SubCode value
     * @param string $subCode
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureType
     */
    public function setSubCode($subCode = null)
    {
        $this->SubCode = $subCode;
        return $this;
    }
    /**
     * Get Vendor value
     * @return string
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param string $vendor
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureType
     */
    public function setVendor($vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get CommercialName value
     * @return string
     */
    public function getCommercialName()
    {
        return $this->CommercialName;
    }
    /**
     * Set CommercialName value
     * @param string $commercialName
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureType
     */
    public function setCommercialName($commercialName = null)
    {
        $this->CommercialName = $commercialName;
        return $this;
    }
    /**
     * Get iD_1 value
     * @return iD_1
     */
    public function getID_1()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureType
     */
    public function setID_1($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
