<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingDetails Structs
 * Meta informations extracted from the WSDL
 * - documentation: Booking Details
 * @subpackage Structs
 */
class BookingDetails extends AbstractStructBase
{
    /**
     * The ClassOfService
     * Meta informations extracted from the WSDL
     * - documentation: Class of Service
     * @var string
     */
    public $ClassOfService;
    /**
     * The MealCodeList
     * Meta informations extracted from the WSDL
     * - documentation: Meal Code list
     * @var string
     */
    public $MealCodeList;
    /**
     * Constructor method for BookingDetails
     * @uses BookingDetails::setClassOfService()
     * @uses BookingDetails::setMealCodeList()
     * @param string $classOfService
     * @param string $mealCodeList
     */
    public function __construct($classOfService = null, $mealCodeList = null)
    {
        $this
            ->setClassOfService($classOfService)
            ->setMealCodeList($mealCodeList);
    }
    /**
     * Get ClassOfService value
     * @return string|null
     */
    public function getClassOfService()
    {
        return $this->ClassOfService;
    }
    /**
     * Set ClassOfService value
     * @param string $classOfService
     * @return \Sabre\BargainFinderMax\Structs\BookingDetails
     */
    public function setClassOfService($classOfService = null)
    {
        $this->ClassOfService = $classOfService;
        return $this;
    }
    /**
     * Get MealCodeList value
     * @return string|null
     */
    public function getMealCodeList()
    {
        return $this->MealCodeList;
    }
    /**
     * Set MealCodeList value
     * @param string $mealCodeList
     * @return \Sabre\BargainFinderMax\Structs\BookingDetails
     */
    public function setMealCodeList($mealCodeList = null)
    {
        $this->MealCodeList = $mealCodeList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\BookingDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
