<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingClassPrefType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Booking class code and preference level for specifying booking classes preferred/not preferred in a request. | The preference level for the booking class.
 * @subpackage Structs
 */
class BookingClassPrefType extends AbstractStructBase
{
    /**
     * The ResBookDesigCode
     * Meta informations extracted from the WSDL
     * - documentation: Booking class code | Used for an Alpha String, length 2 (for letter codes)
     * - use: required
     * - pattern: [A-Z]{1,2}
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for BookingClassPrefType
     * @uses BookingClassPrefType::setResBookDesigCode()
     * @uses BookingClassPrefType::setPreferLevel()
     * @param string $resBookDesigCode
     * @param string $preferLevel
     */
    public function __construct($resBookDesigCode = null, $preferLevel = null)
    {
        $this
            ->setResBookDesigCode($resBookDesigCode)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get ResBookDesigCode value
     * @return string
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \Sabre\BargainFinderMax\Structs\BookingClassPrefType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \Sabre\BargainFinderMax\Structs\BookingClassPrefType
     */
    public function setPreferLevel($preferLevel = null)
    {
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\BookingClassPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
