<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageInformationType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Baggage Information | Information about baggage
 * @subpackage Structs
 */
class BaggageInformationType extends AbstractStructBase
{
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \Sabre\BargainFinderMax\Structs\Segment[]
     */
    public $Segment;
    /**
     * The ProvisionType
     * Meta informations extracted from the WSDL
     * - documentation: Provision Type (e.g. allowance, charges, embargo etc) (BPT) | Provision Type (e.g. allowance, charges, embargo etc) (BPT)
     * - use: required
     * @var string
     */
    public $ProvisionType;
    /**
     * The AirlineCode
     * Meta informations extracted from the WSDL
     * - documentation: Carrier whose baggage provisions apply (SFK) | Carrier whose baggage provisions apply (SFK)
     * - use: required
     * - pattern: \*\*
     * @var string
     */
    public $AirlineCode;
    /**
     * The Allowance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Allowance[]
     */
    public $Allowance;
    /**
     * The Charge
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Charge[]
     */
    public $Charge;
    /**
     * Constructor method for BaggageInformationType
     * @uses BaggageInformationType::setSegment()
     * @uses BaggageInformationType::setProvisionType()
     * @uses BaggageInformationType::setAirlineCode()
     * @uses BaggageInformationType::setAllowance()
     * @uses BaggageInformationType::setCharge()
     * @param \Sabre\BargainFinderMax\Structs\Segment[] $segment
     * @param string $provisionType
     * @param string $airlineCode
     * @param \Sabre\BargainFinderMax\Structs\Allowance[] $allowance
     * @param \Sabre\BargainFinderMax\Structs\Charge[] $charge
     */
    public function __construct(array $segment = array(), $provisionType = null, $airlineCode = null, array $allowance = array(), array $charge = array())
    {
        $this
            ->setSegment($segment)
            ->setProvisionType($provisionType)
            ->setAirlineCode($airlineCode)
            ->setAllowance($allowance)
            ->setCharge($charge);
    }
    /**
     * Get Segment value
     * @return \Sabre\BargainFinderMax\Structs\Segment[]
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Segment[] $segment
     * @return \Sabre\BargainFinderMax\Structs\BaggageInformationType
     */
    public function setSegment(array $segment = array())
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Segment $item
     * @return \Sabre\BargainFinderMax\Structs\BaggageInformationType
     */
    public function addToSegment(\Sabre\BargainFinderMax\Structs\Segment $item)
    {
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Get ProvisionType value
     * @return string
     */
    public function getProvisionType()
    {
        return $this->ProvisionType;
    }
    /**
     * Set ProvisionType value
     * @uses \Sabre\BargainFinderMax\Enums\BaggageProvisionType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\BaggageProvisionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $provisionType
     * @return \Sabre\BargainFinderMax\Structs\BaggageInformationType
     */
    public function setProvisionType($provisionType = null)
    {
        $this->ProvisionType = $provisionType;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \Sabre\BargainFinderMax\Structs\BaggageInformationType
     */
    public function setAirlineCode($airlineCode = null)
    {
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get Allowance value
     * @return \Sabre\BargainFinderMax\Structs\Allowance[]|null
     */
    public function getAllowance()
    {
        return $this->Allowance;
    }
    /**
     * Set Allowance value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Allowance[] $allowance
     * @return \Sabre\BargainFinderMax\Structs\BaggageInformationType
     */
    public function setAllowance(array $allowance = array())
    {
        $this->Allowance = $allowance;
        return $this;
    }
    /**
     * Add item to Allowance value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Allowance $item
     * @return \Sabre\BargainFinderMax\Structs\BaggageInformationType
     */
    public function addToAllowance(\Sabre\BargainFinderMax\Structs\Allowance $item)
    {
        $this->Allowance[] = $item;
        return $this;
    }
    /**
     * Get Charge value
     * @return \Sabre\BargainFinderMax\Structs\Charge[]|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Charge[] $charge
     * @return \Sabre\BargainFinderMax\Structs\BaggageInformationType
     */
    public function setCharge(array $charge = array())
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Add item to Charge value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Charge $item
     * @return \Sabre\BargainFinderMax\Structs\BaggageInformationType
     */
    public function addToCharge(\Sabre\BargainFinderMax\Structs\Charge $item)
    {
        $this->Charge[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\BaggageInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
