<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageChargeType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Baggage Charge type
 * @subpackage Structs
 */
class BaggageChargeType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Baggage Charge ID
     * - use: required
     * @var int
     */
    public $ID;
    /**
     * The EquivalentAmount
     * Meta informations extracted from the WSDL
     * - documentation: Base Price (C52)
     * - use: required
     * @var float
     */
    public $EquivalentAmount;
    /**
     * The EquivalentCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Currency Code (C5B) | Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - use: required
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $EquivalentCurrency;
    /**
     * The FirstPiece
     * Meta informations extracted from the WSDL
     * - documentation: First Occurrence (OC1)
     * - use: optional
     * @var string
     */
    public $FirstPiece;
    /**
     * The LastPiece
     * Meta informations extracted from the WSDL
     * - documentation: Last Occurrence (OC2)
     * - use: optional
     * @var string
     */
    public $LastPiece;
    /**
     * The Description1
     * Meta informations extracted from the WSDL
     * - documentation: Description 1 Text (D01)
     * - use: optional
     * @var string
     */
    public $Description1;
    /**
     * The Description2
     * Meta informations extracted from the WSDL
     * - documentation: Description 2 Text (D02)
     * - use: optional
     * @var string
     */
    public $Description2;
    /**
     * The NoChargeNotAvailable
     * Meta informations extracted from the WSDL
     * - documentation: No Charge Not Available (N43): X - service not available. F - no charge for service (free) and an EMD is not issued to reflect the free service. E - no charge for service (free) and an EMD is issued to reflect the free service. G -
     * no charge for service (free), booking is not required and an EMD is not issued to reflect the free service. H - no charge for service (free), booking is not required and an EMD is issued to reflect the free service. | Used for Characters, length 1 |
     * Used for Characters, length 1
     * - use: optional
     * - length: 1
     * @var string
     */
    public $NoChargeNotAvailable;
    /**
     * Constructor method for BaggageChargeType
     * @uses BaggageChargeType::setID()
     * @uses BaggageChargeType::setEquivalentAmount()
     * @uses BaggageChargeType::setEquivalentCurrency()
     * @uses BaggageChargeType::setFirstPiece()
     * @uses BaggageChargeType::setLastPiece()
     * @uses BaggageChargeType::setDescription1()
     * @uses BaggageChargeType::setDescription2()
     * @uses BaggageChargeType::setNoChargeNotAvailable()
     * @param int $iD
     * @param float $equivalentAmount
     * @param string $equivalentCurrency
     * @param string $firstPiece
     * @param string $lastPiece
     * @param string $description1
     * @param string $description2
     * @param string $noChargeNotAvailable
     */
    public function __construct($iD = null, $equivalentAmount = null, $equivalentCurrency = null, $firstPiece = null, $lastPiece = null, $description1 = null, $description2 = null, $noChargeNotAvailable = null)
    {
        $this
            ->setID($iD)
            ->setEquivalentAmount($equivalentAmount)
            ->setEquivalentCurrency($equivalentCurrency)
            ->setFirstPiece($firstPiece)
            ->setLastPiece($lastPiece)
            ->setDescription1($description1)
            ->setDescription2($description2)
            ->setNoChargeNotAvailable($noChargeNotAvailable);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Sabre\BargainFinderMax\Structs\BaggageChargeType
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get EquivalentAmount value
     * @return float
     */
    public function getEquivalentAmount()
    {
        return $this->EquivalentAmount;
    }
    /**
     * Set EquivalentAmount value
     * @param float $equivalentAmount
     * @return \Sabre\BargainFinderMax\Structs\BaggageChargeType
     */
    public function setEquivalentAmount($equivalentAmount = null)
    {
        $this->EquivalentAmount = $equivalentAmount;
        return $this;
    }
    /**
     * Get EquivalentCurrency value
     * @return string
     */
    public function getEquivalentCurrency()
    {
        return $this->EquivalentCurrency;
    }
    /**
     * Set EquivalentCurrency value
     * @param string $equivalentCurrency
     * @return \Sabre\BargainFinderMax\Structs\BaggageChargeType
     */
    public function setEquivalentCurrency($equivalentCurrency = null)
    {
        $this->EquivalentCurrency = $equivalentCurrency;
        return $this;
    }
    /**
     * Get FirstPiece value
     * @return string|null
     */
    public function getFirstPiece()
    {
        return $this->FirstPiece;
    }
    /**
     * Set FirstPiece value
     * @param string $firstPiece
     * @return \Sabre\BargainFinderMax\Structs\BaggageChargeType
     */
    public function setFirstPiece($firstPiece = null)
    {
        $this->FirstPiece = $firstPiece;
        return $this;
    }
    /**
     * Get LastPiece value
     * @return string|null
     */
    public function getLastPiece()
    {
        return $this->LastPiece;
    }
    /**
     * Set LastPiece value
     * @param string $lastPiece
     * @return \Sabre\BargainFinderMax\Structs\BaggageChargeType
     */
    public function setLastPiece($lastPiece = null)
    {
        $this->LastPiece = $lastPiece;
        return $this;
    }
    /**
     * Get Description1 value
     * @return string|null
     */
    public function getDescription1()
    {
        return $this->Description1;
    }
    /**
     * Set Description1 value
     * @param string $description1
     * @return \Sabre\BargainFinderMax\Structs\BaggageChargeType
     */
    public function setDescription1($description1 = null)
    {
        $this->Description1 = $description1;
        return $this;
    }
    /**
     * Get Description2 value
     * @return string|null
     */
    public function getDescription2()
    {
        return $this->Description2;
    }
    /**
     * Set Description2 value
     * @param string $description2
     * @return \Sabre\BargainFinderMax\Structs\BaggageChargeType
     */
    public function setDescription2($description2 = null)
    {
        $this->Description2 = $description2;
        return $this;
    }
    /**
     * Get NoChargeNotAvailable value
     * @return string|null
     */
    public function getNoChargeNotAvailable()
    {
        return $this->NoChargeNotAvailable;
    }
    /**
     * Set NoChargeNotAvailable value
     * @param string $noChargeNotAvailable
     * @return \Sabre\BargainFinderMax\Structs\BaggageChargeType
     */
    public function setNoChargeNotAvailable($noChargeNotAvailable = null)
    {
        $this->NoChargeNotAvailable = $noChargeNotAvailable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\BaggageChargeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
