<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AwardShoppingType Structs
 * @subpackage Structs
 */
class AwardShoppingType extends AbstractStructBase
{
    /**
     * The Enable
     * Meta informations extracted from the WSDL
     * - documentation: Enable award shopping.
     * - use: optional
     * @var bool
     */
    public $Enable;
    /**
     * The UseRAS
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Use Redemption Availability Service
     * @var bool
     */
    public $UseRAS;
    /**
     * Constructor method for AwardShoppingType
     * @uses AwardShoppingType::setEnable()
     * @uses AwardShoppingType::setUseRAS()
     * @param bool $enable
     * @param bool $useRAS
     */
    public function __construct($enable = null, $useRAS = false)
    {
        $this
            ->setEnable($enable)
            ->setUseRAS($useRAS);
    }
    /**
     * Get Enable value
     * @return bool|null
     */
    public function getEnable()
    {
        return $this->Enable;
    }
    /**
     * Set Enable value
     * @param bool $enable
     * @return \Sabre\BargainFinderMax\Structs\AwardShoppingType
     */
    public function setEnable($enable = null)
    {
        $this->Enable = $enable;
        return $this;
    }
    /**
     * Get UseRAS value
     * @return bool|null
     */
    public function getUseRAS()
    {
        return $this->UseRAS;
    }
    /**
     * Set UseRAS value
     * @param bool $useRAS
     * @return \Sabre\BargainFinderMax\Structs\AwardShoppingType
     */
    public function setUseRAS($useRAS = false)
    {
        $this->UseRAS = $useRAS;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AwardShoppingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
