<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryFeeType Structs
 * @subpackage Structs
 */
class AncillaryFeeType extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: Group Code
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Name
     * - use: required
     * @var string
     */
    public $Name;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - documentation: Ancillary fee details
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType[]
     */
    public $Details;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Message
     * - use: optional
     * @var string
     */
    public $Message;
    /**
     * Constructor method for AncillaryFeeType
     * @uses AncillaryFeeType::setCode()
     * @uses AncillaryFeeType::setName()
     * @uses AncillaryFeeType::setDetails()
     * @uses AncillaryFeeType::setMessage()
     * @param string $code
     * @param string $name
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType[] $details
     * @param string $message
     */
    public function __construct($code = null, $name = null, array $details = array(), $message = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setDetails($details)
            ->setMessage($message);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeType
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Details value
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType[]|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType[] $details
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeType
     */
    public function setDetails(array $details = array())
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Add item to Details value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType $item
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeType
     */
    public function addToDetails(\Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType $item)
    {
        $this->Details[] = $item;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeType
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
