<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryFeeGroupType Structs
 * @subpackage Structs
 */
class AncillaryFeeGroupType extends AbstractStructBase
{
    /**
     * The AncillaryFee
     * Meta informations extracted from the WSDL
     * - documentation: Ancillary service fee group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AncillaryFeeType[]
     */
    public $AncillaryFee;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Message
     * - use: optional
     * @var string
     */
    public $Message;
    /**
     * Constructor method for AncillaryFeeGroupType
     * @uses AncillaryFeeGroupType::setAncillaryFee()
     * @uses AncillaryFeeGroupType::setMessage()
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeType[] $ancillaryFee
     * @param string $message
     */
    public function __construct(array $ancillaryFee = array(), $message = null)
    {
        $this
            ->setAncillaryFee($ancillaryFee)
            ->setMessage($message);
    }
    /**
     * Get AncillaryFee value
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeType[]|null
     */
    public function getAncillaryFee()
    {
        return $this->AncillaryFee;
    }
    /**
     * Set AncillaryFee value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeType[] $ancillaryFee
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeGroupType
     */
    public function setAncillaryFee(array $ancillaryFee = array())
    {
        $this->AncillaryFee = $ancillaryFee;
        return $this;
    }
    /**
     * Add item to AncillaryFee value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeType $item
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeGroupType
     */
    public function addToAncillaryFee(\Sabre\BargainFinderMax\Structs\AncillaryFeeType $item)
    {
        $this->AncillaryFee[] = $item;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeGroupType
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeGroupType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
