<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryFeeDetailsType Structs
 * @subpackage Structs
 */
class AncillaryFeeDetailsType extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: Ancillary fee code | OC Fee Code type
     * - use: required
     * - pattern: [A-Z][A-Z0-9]{2}
     * @var string
     */
    public $Code;
    /**
     * The Carrier
     * Meta informations extracted from the WSDL
     * - documentation: Airline code | Airline carrier code type
     * - use: required
     * - pattern: \*\*
     * @var string
     */
    public $Carrier;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Fee amount
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The StartSegment
     * Meta informations extracted from the WSDL
     * - documentation: Start travel segment
     * - use: required
     * @var int
     */
    public $StartSegment;
    /**
     * The EndSegment
     * Meta informations extracted from the WSDL
     * - documentation: End travel segment
     * - use: required
     * @var int
     */
    public $EndSegment;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Description
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - documentation: Origin airport | Airport code type
     * - use: required | optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - documentation: Destination airport | Airport code type
     * - use: required | optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * @var string
     */
    public $Destination;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: Departure Date
     * - use: optional
     * @var string
     */
    public $DepartureDate;
    /**
     * Constructor method for AncillaryFeeDetailsType
     * @uses AncillaryFeeDetailsType::setCode()
     * @uses AncillaryFeeDetailsType::setCarrier()
     * @uses AncillaryFeeDetailsType::setAmount()
     * @uses AncillaryFeeDetailsType::setStartSegment()
     * @uses AncillaryFeeDetailsType::setEndSegment()
     * @uses AncillaryFeeDetailsType::setDescription()
     * @uses AncillaryFeeDetailsType::setOrigin()
     * @uses AncillaryFeeDetailsType::setDestination()
     * @uses AncillaryFeeDetailsType::setDepartureDate()
     * @param string $code
     * @param string $carrier
     * @param float $amount
     * @param int $startSegment
     * @param int $endSegment
     * @param string $description
     * @param string $origin
     * @param string $destination
     * @param string $departureDate
     */
    public function __construct($code = null, $carrier = null, $amount = null, $startSegment = null, $endSegment = null, $description = null, $origin = null, $destination = null, $departureDate = null)
    {
        $this
            ->setCode($code)
            ->setCarrier($carrier)
            ->setAmount($amount)
            ->setStartSegment($startSegment)
            ->setEndSegment($endSegment)
            ->setDescription($description)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setDepartureDate($departureDate);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType
     */
    public function setCarrier($carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get StartSegment value
     * @return int
     */
    public function getStartSegment()
    {
        return $this->StartSegment;
    }
    /**
     * Set StartSegment value
     * @param int $startSegment
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType
     */
    public function setStartSegment($startSegment = null)
    {
        $this->StartSegment = $startSegment;
        return $this;
    }
    /**
     * Get EndSegment value
     * @return int
     */
    public function getEndSegment()
    {
        return $this->EndSegment;
    }
    /**
     * Set EndSegment value
     * @param int $endSegment
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType
     */
    public function setEndSegment($endSegment = null)
    {
        $this->EndSegment = $endSegment;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType
     */
    public function setOrigin($origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType
     */
    public function setDestination($destination = null)
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
