<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternateTime Structs
 * Meta informations extracted from the WSDL
 * - documentation: Maximum time difference/deviation allowed.
 * - minOccurs: 0
 * @subpackage Structs
 */
class AlternateTime extends AbstractStructBase
{
    /**
     * The PlusMinus
     * Meta informations extracted from the WSDL
     * - documentation: Maximum time difference between actual and desired time. | Used for Numeric values, from 0 to 9 inclusive
     * - use: optional
     * - maxInclusive: 9
     * - minInclusive: 0
     * @var int
     */
    public $PlusMinus;
    /**
     * The Plus
     * Meta informations extracted from the WSDL
     * - documentation: Maximum number of hours after desired time. | Used for Numeric values, from 0 to 9 inclusive
     * - use: optional
     * - maxInclusive: 9
     * - minInclusive: 0
     * @var int
     */
    public $Plus;
    /**
     * The Minus
     * Meta informations extracted from the WSDL
     * - documentation: Maximum number of hours before desired time. | Used for Numeric values, from 0 to 72 inclusive
     * - use: optional
     * - maxInclusive: 72
     * - minInclusive: 0
     * @var int
     */
    public $Minus;
    /**
     * Constructor method for AlternateTime
     * @uses AlternateTime::setPlusMinus()
     * @uses AlternateTime::setPlus()
     * @uses AlternateTime::setMinus()
     * @param int $plusMinus
     * @param int $plus
     * @param int $minus
     */
    public function __construct($plusMinus = null, $plus = null, $minus = null)
    {
        $this
            ->setPlusMinus($plusMinus)
            ->setPlus($plus)
            ->setMinus($minus);
    }
    /**
     * Get PlusMinus value
     * @return int|null
     */
    public function getPlusMinus()
    {
        return $this->PlusMinus;
    }
    /**
     * Set PlusMinus value
     * @param int $plusMinus
     * @return \Sabre\BargainFinderMax\Structs\AlternateTime
     */
    public function setPlusMinus($plusMinus = null)
    {
        $this->PlusMinus = $plusMinus;
        return $this;
    }
    /**
     * Get Plus value
     * @return int|null
     */
    public function getPlus()
    {
        return $this->Plus;
    }
    /**
     * Set Plus value
     * @param int $plus
     * @return \Sabre\BargainFinderMax\Structs\AlternateTime
     */
    public function setPlus($plus = null)
    {
        $this->Plus = $plus;
        return $this;
    }
    /**
     * Get Minus value
     * @return int|null
     */
    public function getMinus()
    {
        return $this->Minus;
    }
    /**
     * Set Minus value
     * @param int $minus
     * @return \Sabre\BargainFinderMax\Structs\AlternateTime
     */
    public function setMinus($minus = null)
    {
        $this->Minus = $minus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AlternateTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
