<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AltCitiesCombinationsType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Which (if any) alt cities locations should be handled in a special way (i.e. Validate instead of precomputed path).
 * @subpackage Structs
 */
class AltCitiesCombinationsType extends AbstractStructBase
{
    /**
     * The Origins
     * Meta informations extracted from the WSDL
     * - default: Main
     * - documentation: Which origins to process in live path (All or Main only)
     * - use: optional
     * @var string
     */
    public $Origins;
    /**
     * The Destinations
     * Meta informations extracted from the WSDL
     * - default: Main
     * - documentation: Which destinations to process in live path (All or Main only)
     * - use: optional
     * @var string
     */
    public $Destinations;
    /**
     * Constructor method for AltCitiesCombinationsType
     * @uses AltCitiesCombinationsType::setOrigins()
     * @uses AltCitiesCombinationsType::setDestinations()
     * @param string $origins
     * @param string $destinations
     */
    public function __construct($origins = 'Main', $destinations = 'Main')
    {
        $this
            ->setOrigins($origins)
            ->setDestinations($destinations);
    }
    /**
     * Get Origins value
     * @return string|null
     */
    public function getOrigins()
    {
        return $this->Origins;
    }
    /**
     * Set Origins value
     * @uses \Sabre\BargainFinderMax\Enums\AltCitiesCombinationsLocationsType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\AltCitiesCombinationsLocationsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $origins
     * @return \Sabre\BargainFinderMax\Structs\AltCitiesCombinationsType
     */
    public function setOrigins($origins = 'Main')
    {
        $this->Origins = $origins;
        return $this;
    }
    /**
     * Get Destinations value
     * @return string|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @uses \Sabre\BargainFinderMax\Enums\AltCitiesCombinationsLocationsType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\AltCitiesCombinationsLocationsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $destinations
     * @return \Sabre\BargainFinderMax\Structs\AltCitiesCombinationsType
     */
    public function setDestinations($destinations = 'Main')
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AltCitiesCombinationsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
