<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlineType Structs
 * @subpackage Structs
 */
class AirlineType extends AbstractStructBase
{
    /**
     * The Operating
     * Meta informations extracted from the WSDL
     * - documentation: Operating airline code
     * - use: required
     * - pattern: [0-9A-Z]{2,3}
     * @var string
     */
    public $Operating;
    /**
     * The Marketing
     * Meta informations extracted from the WSDL
     * - documentation: Marketing airline code
     * - use: required
     * - pattern: [0-9A-Z]{2,3}
     * @var string
     */
    public $Marketing;
    /**
     * Constructor method for AirlineType
     * @uses AirlineType::setOperating()
     * @uses AirlineType::setMarketing()
     * @param string $operating
     * @param string $marketing
     */
    public function __construct($operating = null, $marketing = null)
    {
        $this
            ->setOperating($operating)
            ->setMarketing($marketing);
    }
    /**
     * Get Operating value
     * @return string
     */
    public function getOperating()
    {
        return $this->Operating;
    }
    /**
     * Set Operating value
     * @param string $operating
     * @return \Sabre\BargainFinderMax\Structs\AirlineType
     */
    public function setOperating($operating = null)
    {
        $this->Operating = $operating;
        return $this;
    }
    /**
     * Get Marketing value
     * @return string
     */
    public function getMarketing()
    {
        return $this->Marketing;
    }
    /**
     * Set Marketing value
     * @param string $marketing
     * @return \Sabre\BargainFinderMax\Structs\AirlineType
     */
    public function setMarketing($marketing = null)
    {
        $this->Marketing = $marketing;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AirlineType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
