<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTaxType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Defines the data fields available for air tax.
 * @subpackage Structs
 */
class AirTaxType extends AbstractStructBase
{
    /**
     * The TaxCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the code for the tax. | Used for Character Strings, length 1 to 16
     * - use: required
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $TaxCode;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The CarrierCode
     * Meta informations extracted from the WSDL
     * - documentation: carrier used for this tax | Used for Character Strings, length 1 to 8
     * - use: optional
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $CarrierCode;
    /**
     * The RateUsed
     * Meta informations extracted from the WSDL
     * - documentation: Tax rate used
     * @var float
     */
    public $RateUsed;
    /**
     * The StationCode
     * Meta informations extracted from the WSDL
     * - documentation: Airport code at which the tax or surcharge is being applied
     * @var string
     */
    public $StationCode;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - documentation: Tax Country Code | 2 character country code as defined in ISO3166.
     * - pattern: [a-zA-Z]{2}
     * @var string
     */
    public $CountryCode;
    /**
     * The TaxOnChangeFee
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $TaxOnChangeFee;
    /**
     * The Refundable
     * Meta informations extracted from the WSDL
     * - documentation: Is tax amount refundable during exchange
     * - use: optional
     * @var bool
     */
    public $Refundable;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The MinAmount
     * Meta informations extracted from the WSDL
     * - documentation: Minumum tax amount
     * @var float
     */
    public $MinAmount;
    /**
     * The MaxAmount
     * Meta informations extracted from the WSDL
     * - documentation: Maximum tax amount
     * @var float
     */
    public $MaxAmount;
    /**
     * The MinMaxCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Min/Max tax currency code | Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $MinMaxCurrency;
    /**
     * The ReissueTaxType
     * @var string
     */
    public $ReissueTaxType;
    /**
     * The ReissueRestrictionApplies
     * @var bool
     */
    public $ReissueRestrictionApplies;
    /**
     * The ReissueTaxRefundable
     * @var bool
     */
    public $ReissueTaxRefundable;
    /**
     * The ApplyToReissue
     * @var bool
     */
    public $ApplyToReissue;
    /**
     * The ReissueMaxAmount
     * @var float
     */
    public $ReissueMaxAmount;
    /**
     * The ReissueCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Reissue tax max amount currency | Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $ReissueCurrency;
    /**
     * The PublishedAmount
     * @var float
     */
    public $PublishedAmount;
    /**
     * The PublishedCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $PublishedCurrency;
    /**
     * Constructor method for AirTaxType
     * @uses AirTaxType::setTaxCode()
     * @uses AirTaxType::set_()
     * @uses AirTaxType::setCarrierCode()
     * @uses AirTaxType::setRateUsed()
     * @uses AirTaxType::setStationCode()
     * @uses AirTaxType::setCountryCode()
     * @uses AirTaxType::setTaxOnChangeFee()
     * @uses AirTaxType::setRefundable()
     * @uses AirTaxType::setAmount()
     * @uses AirTaxType::setCurrencyCode()
     * @uses AirTaxType::setDecimalPlaces()
     * @uses AirTaxType::setMinAmount()
     * @uses AirTaxType::setMaxAmount()
     * @uses AirTaxType::setMinMaxCurrency()
     * @uses AirTaxType::setReissueTaxType()
     * @uses AirTaxType::setReissueRestrictionApplies()
     * @uses AirTaxType::setReissueTaxRefundable()
     * @uses AirTaxType::setApplyToReissue()
     * @uses AirTaxType::setReissueMaxAmount()
     * @uses AirTaxType::setReissueCurrency()
     * @uses AirTaxType::setPublishedAmount()
     * @uses AirTaxType::setPublishedCurrency()
     * @param string $taxCode
     * @param string $_
     * @param string $carrierCode
     * @param float $rateUsed
     * @param string $stationCode
     * @param string $countryCode
     * @param bool $taxOnChangeFee
     * @param bool $refundable
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param float $minAmount
     * @param float $maxAmount
     * @param string $minMaxCurrency
     * @param string $reissueTaxType
     * @param bool $reissueRestrictionApplies
     * @param bool $reissueTaxRefundable
     * @param bool $applyToReissue
     * @param float $reissueMaxAmount
     * @param string $reissueCurrency
     * @param float $publishedAmount
     * @param string $publishedCurrency
     */
    public function __construct($taxCode = null, $_ = null, $carrierCode = null, $rateUsed = null, $stationCode = null, $countryCode = null, $taxOnChangeFee = null, $refundable = null, $amount = null, $currencyCode = null, $decimalPlaces = null, $minAmount = null, $maxAmount = null, $minMaxCurrency = null, $reissueTaxType = null, $reissueRestrictionApplies = null, $reissueTaxRefundable = null, $applyToReissue = null, $reissueMaxAmount = null, $reissueCurrency = null, $publishedAmount = null, $publishedCurrency = null)
    {
        $this
            ->setTaxCode($taxCode)
            ->set_($_)
            ->setCarrierCode($carrierCode)
            ->setRateUsed($rateUsed)
            ->setStationCode($stationCode)
            ->setCountryCode($countryCode)
            ->setTaxOnChangeFee($taxOnChangeFee)
            ->setRefundable($refundable)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setMinAmount($minAmount)
            ->setMaxAmount($maxAmount)
            ->setMinMaxCurrency($minMaxCurrency)
            ->setReissueTaxType($reissueTaxType)
            ->setReissueRestrictionApplies($reissueRestrictionApplies)
            ->setReissueTaxRefundable($reissueTaxRefundable)
            ->setApplyToReissue($applyToReissue)
            ->setReissueMaxAmount($reissueMaxAmount)
            ->setReissueCurrency($reissueCurrency)
            ->setPublishedAmount($publishedAmount)
            ->setPublishedCurrency($publishedCurrency);
    }
    /**
     * Get TaxCode value
     * @return string
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setTaxCode($taxCode = null)
    {
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setCarrierCode($carrierCode = null)
    {
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get RateUsed value
     * @return float|null
     */
    public function getRateUsed()
    {
        return $this->RateUsed;
    }
    /**
     * Set RateUsed value
     * @param float $rateUsed
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setRateUsed($rateUsed = null)
    {
        $this->RateUsed = $rateUsed;
        return $this;
    }
    /**
     * Get StationCode value
     * @return string|null
     */
    public function getStationCode()
    {
        return $this->StationCode;
    }
    /**
     * Set StationCode value
     * @param string $stationCode
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setStationCode($stationCode = null)
    {
        $this->StationCode = $stationCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setCountryCode($countryCode = null)
    {
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get TaxOnChangeFee value
     * @return bool|null
     */
    public function getTaxOnChangeFee()
    {
        return $this->TaxOnChangeFee;
    }
    /**
     * Set TaxOnChangeFee value
     * @param bool $taxOnChangeFee
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setTaxOnChangeFee($taxOnChangeFee = null)
    {
        $this->TaxOnChangeFee = $taxOnChangeFee;
        return $this;
    }
    /**
     * Get Refundable value
     * @return bool|null
     */
    public function getRefundable()
    {
        return $this->Refundable;
    }
    /**
     * Set Refundable value
     * @param bool $refundable
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setRefundable($refundable = null)
    {
        $this->Refundable = $refundable;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get MinAmount value
     * @return float|null
     */
    public function getMinAmount()
    {
        return $this->MinAmount;
    }
    /**
     * Set MinAmount value
     * @param float $minAmount
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setMinAmount($minAmount = null)
    {
        $this->MinAmount = $minAmount;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float|null
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setMaxAmount($maxAmount = null)
    {
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get MinMaxCurrency value
     * @return string|null
     */
    public function getMinMaxCurrency()
    {
        return $this->MinMaxCurrency;
    }
    /**
     * Set MinMaxCurrency value
     * @param string $minMaxCurrency
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setMinMaxCurrency($minMaxCurrency = null)
    {
        $this->MinMaxCurrency = $minMaxCurrency;
        return $this;
    }
    /**
     * Get ReissueTaxType value
     * @return string|null
     */
    public function getReissueTaxType()
    {
        return $this->ReissueTaxType;
    }
    /**
     * Set ReissueTaxType value
     * @param string $reissueTaxType
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setReissueTaxType($reissueTaxType = null)
    {
        $this->ReissueTaxType = $reissueTaxType;
        return $this;
    }
    /**
     * Get ReissueRestrictionApplies value
     * @return bool|null
     */
    public function getReissueRestrictionApplies()
    {
        return $this->ReissueRestrictionApplies;
    }
    /**
     * Set ReissueRestrictionApplies value
     * @param bool $reissueRestrictionApplies
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setReissueRestrictionApplies($reissueRestrictionApplies = null)
    {
        $this->ReissueRestrictionApplies = $reissueRestrictionApplies;
        return $this;
    }
    /**
     * Get ReissueTaxRefundable value
     * @return bool|null
     */
    public function getReissueTaxRefundable()
    {
        return $this->ReissueTaxRefundable;
    }
    /**
     * Set ReissueTaxRefundable value
     * @param bool $reissueTaxRefundable
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setReissueTaxRefundable($reissueTaxRefundable = null)
    {
        $this->ReissueTaxRefundable = $reissueTaxRefundable;
        return $this;
    }
    /**
     * Get ApplyToReissue value
     * @return bool|null
     */
    public function getApplyToReissue()
    {
        return $this->ApplyToReissue;
    }
    /**
     * Set ApplyToReissue value
     * @param bool $applyToReissue
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setApplyToReissue($applyToReissue = null)
    {
        $this->ApplyToReissue = $applyToReissue;
        return $this;
    }
    /**
     * Get ReissueMaxAmount value
     * @return float|null
     */
    public function getReissueMaxAmount()
    {
        return $this->ReissueMaxAmount;
    }
    /**
     * Set ReissueMaxAmount value
     * @param float $reissueMaxAmount
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setReissueMaxAmount($reissueMaxAmount = null)
    {
        $this->ReissueMaxAmount = $reissueMaxAmount;
        return $this;
    }
    /**
     * Get ReissueCurrency value
     * @return string|null
     */
    public function getReissueCurrency()
    {
        return $this->ReissueCurrency;
    }
    /**
     * Set ReissueCurrency value
     * @param string $reissueCurrency
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setReissueCurrency($reissueCurrency = null)
    {
        $this->ReissueCurrency = $reissueCurrency;
        return $this;
    }
    /**
     * Get PublishedAmount value
     * @return float|null
     */
    public function getPublishedAmount()
    {
        return $this->PublishedAmount;
    }
    /**
     * Set PublishedAmount value
     * @param float $publishedAmount
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setPublishedAmount($publishedAmount = null)
    {
        $this->PublishedAmount = $publishedAmount;
        return $this;
    }
    /**
     * Get PublishedCurrency value
     * @return string|null
     */
    public function getPublishedCurrency()
    {
        return $this->PublishedCurrency;
    }
    /**
     * Set PublishedCurrency value
     * @param string $publishedCurrency
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public function setPublishedCurrency($publishedCurrency = null)
    {
        $this->PublishedCurrency = $publishedCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
