<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Adjustment Structs
 * @subpackage Structs
 */
class Adjustment extends AbstractStructBase
{
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - documentation: Adjustment Value, can be positive or negative, number or percentage
     * - use: required
     * - pattern: (\+|-)?([0-9]+(\.[0-9]*)?|\.[0-9]+)%?
     * @var string
     */
    public $Value;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - documentation: Currency of Adjustment's Value | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $Currency;
    /**
     * The Group
     * Meta informations extracted from the WSDL
     * - documentation: Markup/Discount Group
     * @var int
     */
    public $Group;
    /**
     * Constructor method for Adjustment
     * @uses Adjustment::setValue()
     * @uses Adjustment::setCurrency()
     * @uses Adjustment::setGroup()
     * @param string $value
     * @param string $currency
     * @param int $group
     */
    public function __construct($value = null, $currency = null, $group = null)
    {
        $this
            ->setValue($value)
            ->setCurrency($currency)
            ->setGroup($group);
    }
    /**
     * Get Value value
     * @return string
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \Sabre\BargainFinderMax\Structs\Adjustment
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Sabre\BargainFinderMax\Structs\Adjustment
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Group value
     * @return int|null
     */
    public function getGroup()
    {
        return $this->Group;
    }
    /**
     * Set Group value
     * @param int $group
     * @return \Sabre\BargainFinderMax\Structs\Adjustment
     */
    public function setGroup($group = null)
    {
        $this->Group = $group;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Adjustment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
