<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ATSETest Structs
 * Meta informations extracted from the WSDL
 * - documentation: Allows ATSE Team to test new features. This element and its content is meant to never be published.
 * @subpackage Structs
 */
class ATSETest extends AbstractStructBase
{
    /**
     * The Feature
     * Meta informations extracted from the WSDL
     * - documentation: Meaning of that attribute is dependent on MIP Team, ISell sends it in all ShoppingRequests when specified.
     * @var string
     */
    public $Feature;
    /**
     * Constructor method for ATSETest
     * @uses ATSETest::setFeature()
     * @param string $feature
     */
    public function __construct($feature = null)
    {
        $this
            ->setFeature($feature);
    }
    /**
     * Get Feature value
     * @return string|null
     */
    public function getFeature()
    {
        return $this->Feature;
    }
    /**
     * Set Feature value
     * @param string $feature
     * @return \Sabre\BargainFinderMax\Structs\ATSETest
     */
    public function setFeature($feature = null)
    {
        $this->Feature = $feature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ATSETest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
