<?php

namespace Sabre\BargainFinderMax\Enums;

/**
 * This class stands for WeightUnitType Enums
 * Meta informations extracted from the WSDL
 * - documentation: Units of weight
 * @subpackage Enumerations
 */
class WeightUnitType
{
    /**
     * Constant for value 'kg'
     * @return string 'kg'
     */
    const VALUE_KG = 'kg';
    /**
     * Constant for value 'lbs'
     * @return string 'lbs'
     */
    const VALUE_LBS = 'lbs';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KG
     * @uses self::VALUE_LBS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KG,
            self::VALUE_LBS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
