<?php

namespace Sabre\BargainFinderMax\Enums;

/**
 * This class stands for OutboundOrInbound Enums
 * @subpackage Enumerations
 */
class OutboundOrInbound
{
    /**
     * Constant for value 'Outbound'
     * @return string 'Outbound'
     */
    const VALUE_OUTBOUND = 'Outbound';
    /**
     * Constant for value 'Inbound'
     * @return string 'Inbound'
     */
    const VALUE_INBOUND = 'Inbound';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OUTBOUND
     * @uses self::VALUE_INBOUND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OUTBOUND,
            self::VALUE_INBOUND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
