<?php

namespace Sabre\BargainFinderMax\Enums;

/**
 * This class stands for GlobalDirection Enums
 * Meta informations extracted from the WSDL
 * - documentation: Global direction type
 * @subpackage Enumerations
 */
class GlobalDirection
{
    /**
     * Constant for value 'AF'
     * @return string 'AF'
     */
    const VALUE_AF = 'AF';
    /**
     * Constant for value 'AL'
     * @return string 'AL'
     */
    const VALUE_AL = 'AL';
    /**
     * Constant for value 'AP'
     * @return string 'AP'
     */
    const VALUE_AP = 'AP';
    /**
     * Constant for value 'AT'
     * @return string 'AT'
     */
    const VALUE_AT = 'AT';
    /**
     * Constant for value 'CA'
     * @return string 'CA'
     */
    const VALUE_CA = 'CA';
    /**
     * Constant for value 'CT'
     * @return string 'CT'
     */
    const VALUE_CT = 'CT';
    /**
     * Constant for value 'DI'
     * @return string 'DI'
     */
    const VALUE_DI = 'DI';
    /**
     * Constant for value 'DO'
     * @return string 'DO'
     */
    const VALUE_DO = 'DO';
    /**
     * Constant for value 'DU'
     * @return string 'DU'
     */
    const VALUE_DU = 'DU';
    /**
     * Constant for value 'EH'
     * @return string 'EH'
     */
    const VALUE_EH = 'EH';
    /**
     * Constant for value 'EM'
     * @return string 'EM'
     */
    const VALUE_EM = 'EM';
    /**
     * Constant for value 'EU'
     * @return string 'EU'
     */
    const VALUE_EU = 'EU';
    /**
     * Constant for value 'FE'
     * @return string 'FE'
     */
    const VALUE_FE = 'FE';
    /**
     * Constant for value 'IN'
     * @return string 'IN'
     */
    const VALUE_IN = 'IN';
    /**
     * Constant for value 'ME'
     * @return string 'ME'
     */
    const VALUE_ME = 'ME';
    /**
     * Constant for value 'NA'
     * @return string 'NA'
     */
    const VALUE_NA = 'NA';
    /**
     * Constant for value 'NP'
     * @return string 'NP'
     */
    const VALUE_NP = 'NP';
    /**
     * Constant for value 'PA'
     * @return string 'PA'
     */
    const VALUE_PA = 'PA';
    /**
     * Constant for value 'PE'
     * @return string 'PE'
     */
    const VALUE_PE = 'PE';
    /**
     * Constant for value 'PN'
     * @return string 'PN'
     */
    const VALUE_PN = 'PN';
    /**
     * Constant for value 'PO'
     * @return string 'PO'
     */
    const VALUE_PO = 'PO';
    /**
     * Constant for value 'PV'
     * @return string 'PV'
     */
    const VALUE_PV = 'PV';
    /**
     * Constant for value 'RU'
     * @return string 'RU'
     */
    const VALUE_RU = 'RU';
    /**
     * Constant for value 'RW'
     * @return string 'RW'
     */
    const VALUE_RW = 'RW';
    /**
     * Constant for value 'SA'
     * @return string 'SA'
     */
    const VALUE_SA = 'SA';
    /**
     * Constant for value 'SN'
     * @return string 'SN'
     */
    const VALUE_SN = 'SN';
    /**
     * Constant for value 'SP'
     * @return string 'SP'
     */
    const VALUE_SP = 'SP';
    /**
     * Constant for value 'TB'
     * @return string 'TB'
     */
    const VALUE_TB = 'TB';
    /**
     * Constant for value 'TS'
     * @return string 'TS'
     */
    const VALUE_TS = 'TS';
    /**
     * Constant for value 'TT'
     * @return string 'TT'
     */
    const VALUE_TT = 'TT';
    /**
     * Constant for value 'US'
     * @return string 'US'
     */
    const VALUE_US = 'US';
    /**
     * Constant for value 'WH'
     * @return string 'WH'
     */
    const VALUE_WH = 'WH';
    /**
     * Constant for value 'XX'
     * @return string 'XX'
     */
    const VALUE_XX = 'XX';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AF
     * @uses self::VALUE_AL
     * @uses self::VALUE_AP
     * @uses self::VALUE_AT
     * @uses self::VALUE_CA
     * @uses self::VALUE_CT
     * @uses self::VALUE_DI
     * @uses self::VALUE_DO
     * @uses self::VALUE_DU
     * @uses self::VALUE_EH
     * @uses self::VALUE_EM
     * @uses self::VALUE_EU
     * @uses self::VALUE_FE
     * @uses self::VALUE_IN
     * @uses self::VALUE_ME
     * @uses self::VALUE_NA
     * @uses self::VALUE_NP
     * @uses self::VALUE_PA
     * @uses self::VALUE_PE
     * @uses self::VALUE_PN
     * @uses self::VALUE_PO
     * @uses self::VALUE_PV
     * @uses self::VALUE_RU
     * @uses self::VALUE_RW
     * @uses self::VALUE_SA
     * @uses self::VALUE_SN
     * @uses self::VALUE_SP
     * @uses self::VALUE_TB
     * @uses self::VALUE_TS
     * @uses self::VALUE_TT
     * @uses self::VALUE_US
     * @uses self::VALUE_WH
     * @uses self::VALUE_XX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AF,
            self::VALUE_AL,
            self::VALUE_AP,
            self::VALUE_AT,
            self::VALUE_CA,
            self::VALUE_CT,
            self::VALUE_DI,
            self::VALUE_DO,
            self::VALUE_DU,
            self::VALUE_EH,
            self::VALUE_EM,
            self::VALUE_EU,
            self::VALUE_FE,
            self::VALUE_IN,
            self::VALUE_ME,
            self::VALUE_NA,
            self::VALUE_NP,
            self::VALUE_PA,
            self::VALUE_PE,
            self::VALUE_PN,
            self::VALUE_PO,
            self::VALUE_PV,
            self::VALUE_RU,
            self::VALUE_RW,
            self::VALUE_SA,
            self::VALUE_SN,
            self::VALUE_SP,
            self::VALUE_TB,
            self::VALUE_TS,
            self::VALUE_TT,
            self::VALUE_US,
            self::VALUE_WH,
            self::VALUE_XX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
