<?php

namespace Sabre\BargainFinderMax\Enums;

/**
 * This class stands for CarrierType Enums
 * Meta informations extracted from the WSDL
 * - documentation: Used to specify if carrier type is marketing or operating.
 * @subpackage Enumerations
 */
class CarrierType
{
    /**
     * Constant for value 'Marketing'
     * @return string 'Marketing'
     */
    const VALUE_MARKETING = 'Marketing';
    /**
     * Constant for value 'Operating'
     * @return string 'Operating'
     */
    const VALUE_OPERATING = 'Operating';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MARKETING
     * @uses self::VALUE_OPERATING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MARKETING,
            self::VALUE_OPERATING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
