<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://files.developer.sabre.com/wsdl/sabreXML1.0.00/shopping/BargainFinderMaxRQ_GIR_v3.2.0.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://files.developer.sabre.com/wsdl/sabreXML1.0.00/shopping/BargainFinderMaxRQ_GIR_v3.2.0.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Sabre\BargainFinderMax\ClassMap::get(),
);
/**
 * Samples for Bargain ServiceType
 */
$bargain = new \Sabre\BargainFinderMax\Services\Bargain($options);
$bargain->setSoapHeaderMessageHeader(new \Sabre\BargainFinderMax\Structs\MessageHeader());
$bargain->setSoapHeaderSecurity(new \Sabre\BargainFinderMax\Structs\Security());
/**
 * Sample call for BargainFinderMaxRQ operation/method
 */
if ($bargain->BargainFinderMaxRQ(new \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRQ()) !== false) {
    print_r($bargain->getResult());
} else {
    print_r($bargain->getLastError());
}
