<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoluntaryChangesSMPType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Specifies charges and/or penalties associated with making ticket changes after purchase.
 * @subpackage Structs
 */
class VoluntaryChangesSMPType extends AbstractStructBase
{
    /**
     * The Penalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Penalty[]
     */
    public $Penalty;
    /**
     * The Match
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Match;
    /**
     * Constructor method for VoluntaryChangesSMPType
     * @uses VoluntaryChangesSMPType::setPenalty()
     * @uses VoluntaryChangesSMPType::setMatch()
     * @param \Sabre\BargainFinderMax\Structs\Penalty[] $penalty
     * @param string $match
     */
    public function __construct(array $penalty = array(), $match = null)
    {
        $this
            ->setPenalty($penalty)
            ->setMatch($match);
    }
    /**
     * Get Penalty value
     * @return \Sabre\BargainFinderMax\Structs\Penalty[]|null
     */
    public function getPenalty()
    {
        return $this->Penalty;
    }
    /**
     * Set Penalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Penalty[] $penalty
     * @return \Sabre\BargainFinderMax\Structs\VoluntaryChangesSMPType
     */
    public function setPenalty(array $penalty = array())
    {
        $this->Penalty = $penalty;
        return $this;
    }
    /**
     * Add item to Penalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Penalty $item
     * @return \Sabre\BargainFinderMax\Structs\VoluntaryChangesSMPType
     */
    public function addToPenalty(\Sabre\BargainFinderMax\Structs\Penalty $item)
    {
        $this->Penalty[] = $item;
        return $this;
    }
    /**
     * Get Match value
     * @return string|null
     */
    public function getMatch()
    {
        return $this->Match;
    }
    /**
     * Set Match value
     * @param string $match
     * @return \Sabre\BargainFinderMax\Structs\VoluntaryChangesSMPType
     */
    public function setMatch($match = null)
    {
        $this->Match = $match;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\VoluntaryChangesSMPType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
