<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidatingCarrierInfoType Structs
 * @subpackage Structs
 */
class ValidatingCarrierInfoType extends AbstractStructBase
{
    /**
     * The Default
     * Meta informations extracted from the WSDL
     * - documentation: Default validating carrier code
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CarrierCountriesType
     */
    public $Default;
    /**
     * The Alternate
     * Meta informations extracted from the WSDL
     * - documentation: Alternate validating carrier code
     * - maxOccurs: 24
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CarrierCountriesType[]
     */
    public $Alternate;
    /**
     * The OtherTicketing
     * Meta informations extracted from the WSDL
     * - documentation: Other possible validating carrier code - IET checked, reprice
     * - maxOccurs: 24
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CarrierCountriesType[]
     */
    public $OtherTicketing;
    /**
     * The SettlementMethod
     * Meta informations extracted from the WSDL
     * - documentation: Used for Strings, length exactly 3
     * - maxLength: 3
     * - minLength: 3
     * @var string
     */
    public $SettlementMethod;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - documentation: 2 character country code as defined in ISO3166.
     * - pattern: [a-zA-Z]{2}
     * @var string
     */
    public $Country;
    /**
     * The NewVcxProcess
     * @var bool
     */
    public $NewVcxProcess;
    /**
     * Constructor method for ValidatingCarrierInfoType
     * @uses ValidatingCarrierInfoType::setDefault()
     * @uses ValidatingCarrierInfoType::setAlternate()
     * @uses ValidatingCarrierInfoType::setOtherTicketing()
     * @uses ValidatingCarrierInfoType::setSettlementMethod()
     * @uses ValidatingCarrierInfoType::setCountry()
     * @uses ValidatingCarrierInfoType::setNewVcxProcess()
     * @param \Sabre\BargainFinderMax\Structs\CarrierCountriesType $default
     * @param \Sabre\BargainFinderMax\Structs\CarrierCountriesType[] $alternate
     * @param \Sabre\BargainFinderMax\Structs\CarrierCountriesType[] $otherTicketing
     * @param string $settlementMethod
     * @param string $country
     * @param bool $newVcxProcess
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\CarrierCountriesType $default = null, array $alternate = array(), array $otherTicketing = array(), $settlementMethod = null, $country = null, $newVcxProcess = null)
    {
        $this
            ->setDefault($default)
            ->setAlternate($alternate)
            ->setOtherTicketing($otherTicketing)
            ->setSettlementMethod($settlementMethod)
            ->setCountry($country)
            ->setNewVcxProcess($newVcxProcess);
    }
    /**
     * Get Default value
     * @return \Sabre\BargainFinderMax\Structs\CarrierCountriesType|null
     */
    public function getDefault()
    {
        return $this->Default;
    }
    /**
     * Set Default value
     * @param \Sabre\BargainFinderMax\Structs\CarrierCountriesType $default
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierInfoType
     */
    public function setDefault(\Sabre\BargainFinderMax\Structs\CarrierCountriesType $default = null)
    {
        $this->Default = $default;
        return $this;
    }
    /**
     * Get Alternate value
     * @return \Sabre\BargainFinderMax\Structs\CarrierCountriesType[]|null
     */
    public function getAlternate()
    {
        return $this->Alternate;
    }
    /**
     * Set Alternate value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CarrierCountriesType[] $alternate
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierInfoType
     */
    public function setAlternate(array $alternate = array())
    {
        $this->Alternate = $alternate;
        return $this;
    }
    /**
     * Add item to Alternate value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CarrierCountriesType $item
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierInfoType
     */
    public function addToAlternate(\Sabre\BargainFinderMax\Structs\CarrierCountriesType $item)
    {
        $this->Alternate[] = $item;
        return $this;
    }
    /**
     * Get OtherTicketing value
     * @return \Sabre\BargainFinderMax\Structs\CarrierCountriesType[]|null
     */
    public function getOtherTicketing()
    {
        return $this->OtherTicketing;
    }
    /**
     * Set OtherTicketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CarrierCountriesType[] $otherTicketing
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierInfoType
     */
    public function setOtherTicketing(array $otherTicketing = array())
    {
        $this->OtherTicketing = $otherTicketing;
        return $this;
    }
    /**
     * Add item to OtherTicketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CarrierCountriesType $item
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierInfoType
     */
    public function addToOtherTicketing(\Sabre\BargainFinderMax\Structs\CarrierCountriesType $item)
    {
        $this->OtherTicketing[] = $item;
        return $this;
    }
    /**
     * Get SettlementMethod value
     * @return string|null
     */
    public function getSettlementMethod()
    {
        return $this->SettlementMethod;
    }
    /**
     * Set SettlementMethod value
     * @param string $settlementMethod
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierInfoType
     */
    public function setSettlementMethod($settlementMethod = null)
    {
        $this->SettlementMethod = $settlementMethod;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierInfoType
     */
    public function setCountry($country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get NewVcxProcess value
     * @return bool|null
     */
    public function getNewVcxProcess()
    {
        return $this->NewVcxProcess;
    }
    /**
     * Set NewVcxProcess value
     * @param bool $newVcxProcess
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierInfoType
     */
    public function setNewVcxProcess($newVcxProcess = null)
    {
        $this->NewVcxProcess = $newVcxProcess;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
