<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidatingCarrierCheck Structs
 * @subpackage Structs
 */
class ValidatingCarrierCheck extends AbstractStructBase
{
    /**
     * The SettlementValidation
     * @var \Sabre\BargainFinderMax\Structs\SettlementValidation
     */
    public $SettlementValidation;
    /**
     * The IETValidation
     * @var \Sabre\BargainFinderMax\Structs\IETValidation
     */
    public $IETValidation;
    /**
     * The Carrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Carrier[]
     */
    public $Carrier;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Country[]
     */
    public $Country;
    /**
     * Constructor method for ValidatingCarrierCheck
     * @uses ValidatingCarrierCheck::setSettlementValidation()
     * @uses ValidatingCarrierCheck::setIETValidation()
     * @uses ValidatingCarrierCheck::setCarrier()
     * @uses ValidatingCarrierCheck::setCountry()
     * @param \Sabre\BargainFinderMax\Structs\SettlementValidation $settlementValidation
     * @param \Sabre\BargainFinderMax\Structs\IETValidation $iETValidation
     * @param \Sabre\BargainFinderMax\Structs\Carrier[] $carrier
     * @param \Sabre\BargainFinderMax\Structs\Country[] $country
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\SettlementValidation $settlementValidation = null, \Sabre\BargainFinderMax\Structs\IETValidation $iETValidation = null, array $carrier = array(), array $country = array())
    {
        $this
            ->setSettlementValidation($settlementValidation)
            ->setIETValidation($iETValidation)
            ->setCarrier($carrier)
            ->setCountry($country);
    }
    /**
     * Get SettlementValidation value
     * @return \Sabre\BargainFinderMax\Structs\SettlementValidation|null
     */
    public function getSettlementValidation()
    {
        return $this->SettlementValidation;
    }
    /**
     * Set SettlementValidation value
     * @param \Sabre\BargainFinderMax\Structs\SettlementValidation $settlementValidation
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierCheck
     */
    public function setSettlementValidation(\Sabre\BargainFinderMax\Structs\SettlementValidation $settlementValidation = null)
    {
        $this->SettlementValidation = $settlementValidation;
        return $this;
    }
    /**
     * Get IETValidation value
     * @return \Sabre\BargainFinderMax\Structs\IETValidation|null
     */
    public function getIETValidation()
    {
        return $this->IETValidation;
    }
    /**
     * Set IETValidation value
     * @param \Sabre\BargainFinderMax\Structs\IETValidation $iETValidation
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierCheck
     */
    public function setIETValidation(\Sabre\BargainFinderMax\Structs\IETValidation $iETValidation = null)
    {
        $this->IETValidation = $iETValidation;
        return $this;
    }
    /**
     * Get Carrier value
     * @return \Sabre\BargainFinderMax\Structs\Carrier[]|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Carrier[] $carrier
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierCheck
     */
    public function setCarrier(array $carrier = array())
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Add item to Carrier value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Carrier $item
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierCheck
     */
    public function addToCarrier(\Sabre\BargainFinderMax\Structs\Carrier $item)
    {
        $this->Carrier[] = $item;
        return $this;
    }
    /**
     * Get Country value
     * @return \Sabre\BargainFinderMax\Structs\Country[]|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Country[] $country
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierCheck
     */
    public function setCountry(array $country = array())
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Add item to Country value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Country $item
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierCheck
     */
    public function addToCountry(\Sabre\BargainFinderMax\Structs\Country $item)
    {
        $this->Country[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierCheck
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
