<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidatingCarrier Structs
 * Meta informations extracted from the WSDL
 * - documentation: Issuing airline whose numeric airline code is reflected in the electronic transaction for the flight/value coupon(s).The Validating Carrier shall be the controlling and authorising entity for Electronic Ticketing transactions.. |
 * Issuing airline whose numeric airline code is reflected in the electronic transaction for the flight/value coupon(s).The Validating Carrier shall be the controlling and authorising entity for Electronic Ticketing transactions..
 * - type: CarrierCode
 * - use: optional
 * @subpackage Structs
 */
class ValidatingCarrier extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: Identifies a company by the company code. | Identifies a company by the company code. | Used for Character Strings, length 1 to 8
     * - use: required
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $Code;
    /**
     * The IETCountryWOBSP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\IETCountryWOBSP
     */
    public $IETCountryWOBSP;
    /**
     * Constructor method for ValidatingCarrier
     * @uses ValidatingCarrier::setCode()
     * @uses ValidatingCarrier::setIETCountryWOBSP()
     * @param string $code
     * @param \Sabre\BargainFinderMax\Structs\IETCountryWOBSP $iETCountryWOBSP
     */
    public function __construct($code = null, \Sabre\BargainFinderMax\Structs\IETCountryWOBSP $iETCountryWOBSP = null)
    {
        $this
            ->setCode($code)
            ->setIETCountryWOBSP($iETCountryWOBSP);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrier
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get IETCountryWOBSP value
     * @return \Sabre\BargainFinderMax\Structs\IETCountryWOBSP|null
     */
    public function getIETCountryWOBSP()
    {
        return $this->IETCountryWOBSP;
    }
    /**
     * Set IETCountryWOBSP value
     * @param \Sabre\BargainFinderMax\Structs\IETCountryWOBSP $iETCountryWOBSP
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrier
     */
    public function setIETCountryWOBSP(\Sabre\BargainFinderMax\Structs\IETCountryWOBSP $iETCountryWOBSP = null)
    {
        $this->IETCountryWOBSP = $iETCountryWOBSP;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
