<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UniqueID_Type Structs
 * Meta informations extracted from the WSDL
 * - documentation: An identifier used to uniquely reference an object in a system (e.g. an airline reservation reference, customer profile reference, booking confirmation number, or a reference to a previous availability quote).
 * @subpackage Structs
 */
class UniqueID_Type extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the company that is associated with the UniqueID.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CompanyNameType
     */
    public $CompanyName;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - documentation: URL that identifies the location associated with the record identified by the UniqueID.
     * @var string
     */
    public $URL;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: A reference to the type of object defined by the UniqueID element. Refer to OTA Code List Unique ID Type (UIT). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * @var string
     */
    public $Type;
    /**
     * The Instance
     * Meta informations extracted from the WSDL
     * - documentation: The identification of a record as it exists at a point in time. An instance is used in update messages where the sender must assure the server that the update sent refers to the most recent modification level of the object being
     * updated. | Used for Character Strings, length 1 to 32
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $Instance;
    /**
     * The ID_Context
     * Meta informations extracted from the WSDL
     * - documentation: Used to identify the source of the identifier (e.g. IATA, ABTA, etc.). | Used for Character Strings, length 1 to 32
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $ID_Context;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: A unique identifying value assigned by the creating system. The ID attribute may be used to reference a primary-key value within a database or in a particular implementation. | A unique identifying value assigned by the creating
     * system. The ID attribute may be used to reference a primary-key value within a database or in a particular implementation. | Used for Character Strings, length 1 to 32
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $ID;
    /**
     * Constructor method for UniqueID_Type
     * @uses UniqueID_Type::setCompanyName()
     * @uses UniqueID_Type::setURL()
     * @uses UniqueID_Type::setType()
     * @uses UniqueID_Type::setInstance()
     * @uses UniqueID_Type::setID_Context()
     * @uses UniqueID_Type::setID()
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType $companyName
     * @param string $uRL
     * @param string $type
     * @param string $instance
     * @param string $iD_Context
     * @param string $iD
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\CompanyNameType $companyName = null, $uRL = null, $type = null, $instance = null, $iD_Context = null, $iD = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setURL($uRL)
            ->setType($type)
            ->setInstance($instance)
            ->setID_Context($iD_Context)
            ->setID($iD);
    }
    /**
     * Get CompanyName value
     * @return \Sabre\BargainFinderMax\Structs\CompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType $companyName
     * @return \Sabre\BargainFinderMax\Structs\UniqueID_Type
     */
    public function setCompanyName(\Sabre\BargainFinderMax\Structs\CompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \Sabre\BargainFinderMax\Structs\UniqueID_Type
     */
    public function setURL($uRL = null)
    {
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\BargainFinderMax\Structs\UniqueID_Type
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Instance value
     * @return string|null
     */
    public function getInstance()
    {
        return $this->Instance;
    }
    /**
     * Set Instance value
     * @param string $instance
     * @return \Sabre\BargainFinderMax\Structs\UniqueID_Type
     */
    public function setInstance($instance = null)
    {
        $this->Instance = $instance;
        return $this;
    }
    /**
     * Get ID_Context value
     * @return string|null
     */
    public function getID_Context()
    {
        return $this->ID_Context;
    }
    /**
     * Set ID_Context value
     * @param string $iD_Context
     * @return \Sabre\BargainFinderMax\Structs\UniqueID_Type
     */
    public function setID_Context($iD_Context = null)
    {
        $this->ID_Context = $iD_Context;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \Sabre\BargainFinderMax\Structs\UniqueID_Type
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\UniqueID_Type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
