<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerRating Structs
 * Meta informations extracted from the WSDL
 * - documentation: Customer Value Scores and Frequent Flyer Tiers for one traveler. It can influence Availability results when provided.
 * @subpackage Structs
 */
class TravelerRating extends AbstractStructBase
{
    /**
     * The Score
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Score[]
     */
    public $Score;
    /**
     * The FrequentFlyer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FrequentFlyer[]
     */
    public $FrequentFlyer;
    /**
     * Constructor method for TravelerRating
     * @uses TravelerRating::setScore()
     * @uses TravelerRating::setFrequentFlyer()
     * @param \Sabre\BargainFinderMax\Structs\Score[] $score
     * @param \Sabre\BargainFinderMax\Structs\FrequentFlyer[] $frequentFlyer
     */
    public function __construct(array $score = array(), array $frequentFlyer = array())
    {
        $this
            ->setScore($score)
            ->setFrequentFlyer($frequentFlyer);
    }
    /**
     * Get Score value
     * @return \Sabre\BargainFinderMax\Structs\Score[]|null
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Score[] $score
     * @return \Sabre\BargainFinderMax\Structs\TravelerRating
     */
    public function setScore(array $score = array())
    {
        $this->Score = $score;
        return $this;
    }
    /**
     * Add item to Score value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Score $item
     * @return \Sabre\BargainFinderMax\Structs\TravelerRating
     */
    public function addToScore(\Sabre\BargainFinderMax\Structs\Score $item)
    {
        $this->Score[] = $item;
        return $this;
    }
    /**
     * Get FrequentFlyer value
     * @return \Sabre\BargainFinderMax\Structs\FrequentFlyer[]|null
     */
    public function getFrequentFlyer()
    {
        return $this->FrequentFlyer;
    }
    /**
     * Set FrequentFlyer value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FrequentFlyer[] $frequentFlyer
     * @return \Sabre\BargainFinderMax\Structs\TravelerRating
     */
    public function setFrequentFlyer(array $frequentFlyer = array())
    {
        $this->FrequentFlyer = $frequentFlyer;
        return $this;
    }
    /**
     * Add item to FrequentFlyer value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FrequentFlyer $item
     * @return \Sabre\BargainFinderMax\Structs\TravelerRating
     */
    public function addToFrequentFlyer(\Sabre\BargainFinderMax\Structs\FrequentFlyer $item)
    {
        $this->FrequentFlyer[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TravelerRating
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
